% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_survfit.R
\name{tbl_survfit}
\alias{tbl_survfit}
\alias{tbl_survfit.survfit}
\alias{tbl_survfit.data.frame}
\alias{tbl_survfit.list}
\title{Survival table}
\usage{
tbl_survfit(x, ...)

\method{tbl_survfit}{survfit}(x, ...)

\method{tbl_survfit}{data.frame}(x, y, include = everything(), ...)

\method{tbl_survfit}{list}(
  x,
  times = NULL,
  probs = NULL,
  statistic = "{estimate} ({conf.low}, {conf.high})",
  label = NULL,
  label_header = ifelse(!is.null(times), "**Time {time}**",
    "**{style_sigfig(prob, scale=100)}\% Percentile**"),
  estimate_fun = ifelse(!is.null(times), label_style_percent(symbol = TRUE),
    label_style_sigfig()),
  missing = "--",
  conf.level = 0.95,
  type = NULL,
  reverse = FALSE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{x}{(\code{survfit}, \code{list}, \code{data.frame})\cr
a survfit object, list of survfit objects, or a data frame.
If a data frame is passed, a list of survfit objects is constructed using
each variable as a stratifying variable.}

\item{...}{For \code{\link[=tbl_survfit.data.frame]{tbl_survfit.data.frame()}}  and \code{\link[=tbl_survfit.survfit]{tbl_survfit.survfit()}} the arguments
are passed to \code{\link[=tbl_survfit.list]{tbl_survfit.list()}}. They are not used when \code{\link[=tbl_survfit.list]{tbl_survfit.list()}}
is called directly.}

\item{y}{outcome call, e.g. \code{y = Surv(ttdeath, death)}}

\item{include}{Variable to include as stratifying variables.}

\item{times}{(\code{numeric})\cr
a vector of times for which to return survival probabilities.}

\item{probs}{(\code{numeric})\cr
a vector of probabilities with values in (0,1) specifying the survival quantiles to return.}

\item{statistic}{(\code{string})\cr
string defining the statistics to present in the table.
Default is \code{"{estimate} ({conf.low}, {conf.high})"}}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
List of formulas specifying variables labels,
e.g. \code{list(age = "Age, yrs", stage = "Path T Stage")}, or a string for a
single variable table.}

\item{label_header}{(\code{string})\cr
string specifying column labels above statistics. Default
is \code{"{prob} Percentile"} for survival percentiles, and \code{"Time {time}"} for n-year
survival estimates}

\item{estimate_fun}{(\code{function})\cr
function to format the Kaplan-Meier estimates. Default
is \code{\link[=label_style_percent]{label_style_percent()}} for survival probabilities and \code{\link[=label_style_sigfig]{label_style_sigfig()}} for
survival times}

\item{missing}{(\code{string})\cr
text to fill when estimate is not estimable. Default is \code{"--"}}

\item{conf.level}{(scalar \code{numeric})\cr ]
Confidence level for confidence intervals. Default is \code{0.95}}

\item{type}{(\code{string} or \code{NULL})\cr
type of statistic to report. Available for Kaplan-Meier time estimates only, otherwise \code{type}
is ignored. Default is \code{NULL}.
Must be one of the following:\tabular{ll}{
   type \tab transformation \cr
   \code{"survival"} \tab \code{x} \cr
   \code{"risk"} \tab \code{1 - x} \cr
   \code{"cumhaz"} \tab \code{-log(x)} \cr
}}

\item{reverse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
Function takes a \code{survfit} object as an argument, and provides a
formatted summary table of the results
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed("survival", reference_pkg = "gtsummary")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

# Example 1 ----------------------------------
# Pass single survfit() object
tbl_survfit(
  survfit(Surv(ttdeath, death) ~ trt, trial),
  times = c(12, 24),
  label_header = "**{time} Month**"
)

# Example 2 ----------------------------------
# Pass a data frame
tbl_survfit(
  trial,
  y = "Surv(ttdeath, death)",
  include = c(trt, grade),
  probs = 0.5,
  label_header = "**Median Survival**"
)

# Example 3 ----------------------------------
# Pass a list of survfit() objects
list(survfit(Surv(ttdeath, death) ~ 1, trial),
     survfit(Surv(ttdeath, death) ~ trt, trial)) |>
  tbl_survfit(times = c(12, 24))

# Example 4 Competing Events Example ---------
# adding a competing event for death (cancer vs other causes)
set.seed(1123)
library(dplyr, warn.conflicts = FALSE, quietly = TRUE)
trial2 <- trial |>
  dplyr::mutate(
    death_cr =
      dplyr::case_when(
        death == 0 ~ "censor",
        runif(n()) < 0.5 ~ "death from cancer",
        TRUE ~ "death other causes"
      ) |>
      factor()
  )

survfit(Surv(ttdeath, death_cr) ~ grade, data = trial2) |>
  tbl_survfit(times = c(12, 24), label = "Tumor Grade")
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
