% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_fmt_fun.R
\name{modify_fmt_fun}
\alias{modify_fmt_fun}
\title{Modify formatting functions}
\usage{
modify_fmt_fun(x, ..., rows = NULL, update, quiet)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{...}{\code{\link[rlang:dyn-dots]{dynamic-dots}}\cr
Used to assign updates to formatting functions.

Use \verb{modify_fmt_fun(colname = <fmt fn>)} to update a single column. Using a
formula will invoke tidyselect, e.g. \verb{modify_fmt_fun(c(estimate, conf.low, conf.high) ~ <fmt_fun>)}.

Use the \code{show_header_names()} to see the column names that can be modified.}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Can be used to style footnote, formatting functions, missing symbols,
and text formatting. Default is \code{NULL}. See details below.}

\item{update, quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
Use this function to update the way numeric columns and rows of \code{.$table_body}
are formatted
}
\section{rows argument}{

The rows argument accepts a predicate expression that is used to specify
rows to apply formatting. The expression must evaluate to a logical when
evaluated in \code{x$table_body}. For example, to apply formatting to the age rows
pass \code{rows = variable == "age"}. A vector of row numbers is NOT acceptable.

A couple of things to note when using the \code{rows} argument.
\enumerate{
\item You can use saved objects to create the predicate argument, e.g.
\code{rows = variable == letters[1]}.
\item The saved object cannot share a name with a column in \code{x$table_body}.
The reason for this is that in \code{tbl_merge()} the columns are renamed,
and the renaming process cannot disambiguate the \code{variable} column from
an external object named \code{variable} in the following expression
\code{rows = .data$variable = .env$variable}.
}
}

\examples{
# Example 1 ----------------------------------
# show 'grade' p-values to 3 decimal places and estimates to 4 sig figs
lm(age ~ marker + grade, trial) |>
  tbl_regression() \%>\%
  modify_fmt_fun(
    p.value = label_style_pvalue(digits = 3),
    c(estimate, conf.low, conf.high) ~ label_style_sigfig(digits = 4),
    rows = variable == "grade"
  )
}
