% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_caption.R
\name{modify_caption}
\alias{modify_caption}
\title{Modify table caption}
\usage{
modify_caption(x, caption, text_interpret = c("md", "html"))
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{caption}{(\code{string}/\code{character})\cr
A string for the table caption/title. NOTE: The \code{gt} print engine supports a
vector of captions. But not every print engine supports this feature, and
for those outputs, only a string is accepted.}

\item{text_interpret}{(\code{string})\cr
String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.
Applies to tables printed with \code{{gt}}.}
}
\value{
Updated gtsummary object
}
\description{
Captions are assigned based on output type.
\itemize{
\item \code{gt::gt(caption=)}
\item \code{flextable::set_caption(caption=)}
\item \code{huxtable::set_caption(value=)}
\item \code{knitr::kable(caption=)}
}
}
\examples{
trial |>
  tbl_summary(by = trt, include = c(marker, stage)) |>
  modify_caption(caption = "**Baseline Characteristics** N = {N}")
}
