#' @title  Bootstrap Analyses of Hydrological Model Error
#' @docType package
#' @name gumboot-package
#'
#' @description
#' Does jackknife after bootstrap analyses of the error in hydrological models by
#' estimating the empirical probability distributions of NSE (Nash-Sutcliffe efficiency) and KGE (Kling-Gupta efficiency)
#' estimators.
#'
#' @author \strong{Coded by:} Martyn Clark and Kevin Shook
#' @author \strong{Maintained by:} Kevin Shook \email{kevin.shook@usask.ca}
#'
#' @section Funding:
#'
#' The package was partly funded by the Global institute for Water Security (GIWS; \href{https://water.usask.ca/}{https://water.usask.ca/}) and the Global Water Futures (GWF; \href{https://gwf.usask.ca/}{https://gwf.usask.ca/}) program.
#' @references
#'  The package code is described in: \cr
#'  \cite{Clark et al. (2021), "The abuse of popular performance metrics in hydrologic modeling", Water Resources Research, <doi:10.1029/2020WR029001>.}
#'
#' @import dplyr hydroGOF ggplot2 lubridate stringr ncdf4
NULL

