% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_conductance.R
\name{convert_conductance}
\alias{convert_conductance}
\title{Convert conductance units}
\usage{
convert_conductance(.g, P = set_units(101.3246, kPa),
  R = set_units(8.31446, J/K/mol), Temp = set_units(298.15, K))
}
\arguments{
\item{.g}{Conductance in class units. Units must convertible to one of "m/s", "umol/m^2/s/Pa", or "mol/m^2/s"}

\item{P}{A pressure value of class \code{units} that is convertible to kPa. Default is 101.3246 kPa, Earth's atmospheric pressure at sea level.}

\item{R}{Ideal gas constant of class \code{units} that is convertible to J/K/kg. Default is 8.31446 J/K/mol.}

\item{Temp}{A temperature value of class \code{units} that is convertible to K. Default is 25 degreeC (298.15 K).}
}
\value{
@return a \link[tibble:tibble-package]{tibble} in units "m/s", "umol/m^2/s/Pa", and "mol/m^2/s".
}
\description{
Convert conductance units
}
\examples{

# library(gunit)
library(units)

g_sc <- set_units(10, "m/s")
convert_conductance(g_sc)

g_sc <- set_units(4, "umol/m^2/s/Pa")
convert_conductance(g_sc)

g_sc <- set_units(0.4, "mol/m^2/s")
convert_conductance(g_sc)

}
