% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{variant_to_trait}
\alias{variant_to_trait}
\title{Map a variant id to an EFO trait}
\usage{
variant_to_trait(
  variant_id,
  keep_association_id = FALSE,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{variant_id}{A character vector of variant identifiers.}

\item{keep_association_id}{Whether to keep the association identifier
in the final output (default is \code{FALSE}).}

\item{verbose}{Whether the function should be
verbose about the different queries or not.}

\item{warnings}{Whether to print warnings.}
}
\value{
A dataframe of two or three identifiers. If
  \code{keep_association_id} is set to \code{FALSE}, the first column is the
  variant identifier and the second column is the EFO trait identifier,
  otherwise the variable \code{association_id} is also included as the second
  column.
}
\description{
Map a variant identifier to an EFO trait identifier. Variants are first
mapped to association identifiers, and then to EFO traits. Set the option
\code{keep_association_id} to \code{TRUE} to keep the intermediate mapping,
i.e., the association identifiers.
}
\examples{
\dontrun{
# Map GWAS variant identifiers to EFO trait identifiers
variant_to_trait(c('rs7904579', 'rs138331350'))

# Map GWAS variant identifiers to EFO trait identifiers
# but keep the intermediate association identifier
variant_to_trait(c('rs7904579', 'rs138331350'), keep_association_id = TRUE)
}

}
