% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basin.R
\name{get_basin_interactively}
\alias{get_basin_interactively}
\title{Get Watershed Basin Interactively}
\usage{
get_basin_interactively(
  ns = "basin-ui",
  viewer = shiny::paneViewer(),
  title = "Delineate Basin",
  ...
)
}
\arguments{
\item{ns}{\code{string} name for the Shiny \code{namespace} to use.  The \code{ns}
is unlikely to require a change.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{title}{\code{string} to customize the title of the UI window.  The default
is "Delineate Basin".}

\item{...}{other arguments to \code{leafletOutput()} in module.}
}
\value{
A list of sf objects that the user collected during shiny session.
}
\description{
This function allows the user delineate watershed basins interactively with a
shiny app. It uses the {elevatr} package for DEM and {whitebox} package to delineate the watershed.
}
\examples{

if(interactive()){
nhdplus_data <- get_basin_interactively()
}

}
