% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{prepareComputePlan}
\alias{prepareComputePlan}
\title{Return a suitable compute plan for a genome-wide association study}
\usage{
prepareComputePlan(model, snpData, out = "out.log", ..., SNP = NULL,
  startFrom = 1L)
}
\arguments{
\item{model}{an instance of \link[OpenMx:MxModel-class]{MxModel}}

\item{snpData}{the name of the file where the SNP data is stored}

\item{out}{the filename where the results of fitted models shall be written}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{SNP}{a vector of SNP indices to include in the analysis; NULL is interpreted as all available SNPs}

\item{startFrom}{the index to start from when \code{SNP=NULL}}
}
\value{
The given model with an appropriate compute plan.
}
\description{
Instead of using OpenMx's default model processing sequence (i.e.,
\link[OpenMx]{omxDefaultComputePlan}), it is more efficient and
convienient to assemble a compute plan tailored for a genome-wide
association study.  This function returns a compute plan that loads
SNP data into model \code{modelName}, fits the model, outputs the
results to \code{out}, and repeats this procedure for all SNPs.
}
\details{
You can request a specific list of SNPs using the \code{SNP}
argument. The numbers provided in \code{SNP} refer to offsets in
the \code{snpData} file. For example, \code{SNP=c(100,200)} will
process the 100th and 200th SNP. The first SNP in the
\code{snpData} file is at offset 1. When \code{SNP} is omitted then
all available SNPs are processed.

The suffix of \code{snpData} filename is interpreted to signal the
format of how the SNP data is stored on disk. Suffixes
\sQuote{pgen}, \sQuote{bed}, and \sQuote{bgen} are supported.
Per-SNP descriptions are found in different places depending on the
suffix. For \sQuote{bgen}, both the SNP data and description are
built into the same file. In the case of \sQuote{pgen}, an
associated file with suffix \sQuote{pvar} is expected to exist (see
the
\href{https://www.cog-genomics.org/plink/2.0/formats#pvar}{spec}
for details). In the case of \sQuote{bed}, an associated
\sQuote{bim} file is expected to exist (see the
\href{https://www.cog-genomics.org/plink2/formats#bim}{spec} for
details). The chromosome, base-pair coordinate, and variant ID are
added to each line of \code{out}.

A compute plan does not do anything by itself. You'll need to combine
the compute plan with a model (such as returned by \link{buildOneFac})
to perform a GWAS.
}
\examples{
m1 <- mxModel("test", mxFitFunctionWLS())
dir <- system.file("extdata", package = "gwsem")
m1 <- prepareComputePlan(m1, file.path(dir,"example.pgen"))
m1$compute
}
\seealso{
\link{GWAS}
}
