% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.matrix.h2o}
\alias{as.matrix.H2OFrame}
\alias{as.matrix.h2o}
\title{Converts H2O Data to an R Matrix}
\usage{
\method{as.matrix}{H2OFrame}(x, ...)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object}

\item{\dots}{Additional arguments to be passed to or from}
}
\value{
Returns a matrix in the R enviornment.
}
\description{
Convert an \linkS4class{H2OFrame} object to a matrix, which allows subsequent data frame operations within the R environment.
}
\note{
This call establishes the data set in the R environment and subsequent operations on the matrix take place
      within R, not H2O. When data are large, users may experience significant slowdown.
}
\examples{
library(h2o)
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
prostate.matrix <- as.matrix(prostate.hex)
summary(prostate.matrix)
head(prostate.matrix)
}
\seealso{
\code{\link[base]{as.matrix}} for the base \code{R} implementation.
}

