% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/export.R
\name{h2o.saveMojo}
\alias{h2o.saveMojo}
\title{Save an H2O Model Object as Mojo to Disk}
\usage{
h2o.saveMojo(object, path = "", force = FALSE)
}
\arguments{
\item{object}{an \linkS4class{H2OModel} object.}

\item{path}{string indicating the directory the model will be written to.}

\item{force}{logical, indicates how to deal with files that already exist.}
}
\description{
Save an MOJO (Model Object, Optimized) to disk.
}
\details{
MOJO will download as a zip file. In the case of existing files \code{force = TRUE}
will overwrite the file. Otherwise, the operation will fail.
}
\examples{
\dontrun{
# library(h2o)
# h2o.init()
# prostate.hex <- h2o.uploadFile(path = system.file("extdata", "prostate.csv", package="h2o"))
# prostate.glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"),
#                         training_frame = prostate.hex, family = "binomial", alpha = 0.5)
# h2o.saveMojo(object = prostate.glm, path = "/Users/UserName/Desktop", force=TRUE)
}
}
\seealso{
\code{\link{h2o.saveModel}} for saving a model to disk as a binary object.
}

