% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.dct}
\alias{h2o.dct}
\title{Compute DCT of an H2OFrame}
\usage{
h2o.dct(data, destination_frame, dimensions, inverse = F)
}
\arguments{
\item{data}{An \linkS4class{H2OFrame} object representing the dataset to transform}

\item{destination_frame}{A frame ID for the result}

\item{dimensions}{An array containing the 3 integer values for height, width, depth of each sample.
The product of HxWxD must total up to less than the number of columns.
For 1D, use c(L,1,1), for 2D, use C(N,M,1).}

\item{inverse}{Whether to perform the inverse transform}
}
\description{
Compute the Discrete Cosine Transform of every row in the H2OFrame
}
\examples{
\donttest{
  library(h2o)
  localH2O = h2o.init()
  df <- h2o.createFrame(localH2O, rows = 1000, cols = 8*16*24,
                        categorical_fraction = 0, integer_fraction = 0, missing_fraction = 0)
  df1 <- h2o.dct(data=df, dimensions=c(8*16*24,1,1))
  df2 <- h2o.dct(data=df1,dimensions=c(8*16*24,1,1),inverse=TRUE)
  max(abs(df1-df2))

  df1 <- h2o.dct(data=df, dimensions=c(8*16,24,1))
  df2 <- h2o.dct(data=df1,dimensions=c(8*16,24,1),inverse=TRUE)
  max(abs(df1-df2))

  df1 <- h2o.dct(data=df, dimensions=c(8,16,24))
  df2 <- h2o.dct(data=df1,dimensions=c(8,16,24),inverse=TRUE)
  max(abs(df1-df2))
}
}

