% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.ifelse}
\alias{h2o.ifelse}
\alias{ifelse,ANY,H2OFrame,H2OFrame-method}
\alias{ifelse,H2OFrame,ANY,ANY-method}
\title{H2O Apply Conditional Statement}
\usage{
h2o.ifelse(test, yes, no)

\S4method{ifelse}{H2OFrame,ANY,ANY}(test, yes, no)

\S4method{ifelse}{ANY,H2OFrame,H2OFrame}(test, yes, no)
}
\arguments{
\item{test}{A logical description of the condition to be met (>, <, =, etc...)}

\item{yes}{The value to return if the condition is TRUE.}

\item{no}{The value to return if the condition is FALSE.}
}
\value{
Returns a vector of new values matching the conditions stated in the ifelse call.
}
\description{
Applies conditional statements to numeric vectors in H2O parsed data objects when the data are
numeric.
}
\details{
Only numeric values can be tested, and only numeric results can be returned for either condition.
Categorical data is not currently supported for this funciton and returned values cannot be
categorical in nature.
}
\examples{
\donttest{
localH2O = h2o.init(ip = "localhost", port = 54321, startH2O = TRUE)
ausPath = system.file("extdata", "australia.csv", package="h2o")
australia.hex = h2o.importFile(localH2O, path = ausPath)
australia.hex[,9] <- ifelse(australia.hex[,3] < 279.9, 1, 0)
summary(australia.hex)
}
}

