% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/models.R
\name{staged_predict_proba.H2OModel}
\alias{h2o.staged_predict_proba}
\alias{staged_predict_proba.H2OModel}
\title{Predict class probabilities at each stage of an H2O Model}
\usage{
staged_predict_proba.H2OModel(object, newdata, ...)

h2o.staged_predict_proba(object, newdata, ...)
}
\arguments{
\item{object}{a fitted \linkS4class{H2OModel} object for which prediction is
desired}

\item{newdata}{An H2OFrame object in which to look for
variables with which to predict.}

\item{...}{additional arguments to pass on.}
}
\value{
Returns an H2OFrame object with predicted probability for each tree in the model.
}
\description{
The output structure is analogous to the output of \link{h2o.predict_leaf_node_assignment}. For each tree t and
class c there will be a column Tt.Cc (eg. T3.C1 for tree 3 and class 1). The value will be the corresponding
predicted probability of this class by combining the raw contributions of trees T1.Cc,..,TtCc. Binomial models build
the trees just for the first class and values in columns Tx.C1 thus correspond to the the probability p0.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
prostate.hex$CAPSULE <- as.factor(prostate.hex$CAPSULE)
prostate.gbm <- h2o.gbm(3:9, "CAPSULE", prostate.hex)
h2o.predict(prostate.gbm, prostate.hex)
h2o.staged_predict_proba(prostate.gbm, prostate.hex)
}
}
\seealso{
\code{\link{h2o.gbm}} and  \code{\link{h2o.randomForest}} for model
         generation in h2o.
}

