% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{h2o.save_to_hive}
\alias{h2o.save_to_hive}
\title{Save contents of this data frame into a Hive table}
\usage{
h2o.save_to_hive(
  data,
  jdbc_url,
  table_name,
  format = "csv",
  table_path = NULL,
  tmp_path = NULL
)
}
\arguments{
\item{data}{A H2O Frame object to be saved.}

\item{jdbc_url}{Hive JDBC connection URL.}

\item{table_name}{Table name into which to store the data. The table must not exist as it will be created}

\item{format}{Storage format of created Hive table. (default csv, can be csv or parquet)}

\item{table_path}{If specified, the table will be created as an external table and this is where the data}

\item{tmp_path}{Path where to store temporary data.}
}
\description{
For example,
    h2o.save_to_hive(data_frame, "jdbc:hive2://host:10000/database", "table_name")
    h2o.save_to_hive(data_frame, "jdbc:hive2://host:10000/", "database.table_name", format = "parquet")
}
