% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{h2o.load_frame}
\alias{h2o.load_frame}
\title{Load frame previously stored in H2O's native format.}
\usage{
h2o.load_frame(frame_id, dir, force = TRUE)
}
\arguments{
\item{frame_id}{the frame ID of the original frame}

\item{dir}{a filesystem location where to look for frame data}

\item{force}{\code{logical}. overwrite an already existing frame (defaults to true)}
}
\description{
Load frame previously stored in H2O's native format.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path = system.file("extdata", "prostate.csv", package = "h2o")
prostate = h2o.importFile(path = prostate_path)
h2o.save_frame(prostate, "/tmp/prostate")
prostate.key <- h2o.getId(prostate)
h2o.rm(prostate)
prostate <- h2o.load_frame(prostate.key, "/tmp/prostate")
}
}
