% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communication.R
\name{.h2o.doSafeGET}
\alias{.h2o.doSafeGET}
\title{Perform a safe (i.e. error-checked) HTTP GET request to an H2O cluster.}
\usage{
.h2o.doSafeGET(h2oRestApiVersion, urlSuffix, parms, ...)
}
\arguments{
\item{h2oRestApiVersion}{(Optional) A version number to prefix to the urlSuffix.  If no version is provided, a default version is chosen for you.}

\item{urlSuffix}{The partial URL suffix to add to the calculated base URL for the instance}

\item{parms}{(Optional) Parameters to include in the request}

\item{...}{(Optional) Additional parameters.}
}
\value{
The raw response payload as a character vector
}
\description{
This function validates that no CURL error occurred and that the HTTP response code is successful.
If a failure occurred, then stop() is called with an error message.
Since all necessary error checking is done inside this call, the valid payload is directly returned if the function successfully finishes without calling stop().
}
