% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.performance}
\alias{h2o.performance}
\title{Model Performance Metrics in H2O}
\usage{
h2o.performance(
  model,
  newdata = NULL,
  train = FALSE,
  valid = FALSE,
  xval = FALSE,
  data = NULL,
  auc_type = "NONE"
)
}
\arguments{
\item{model}{An \linkS4class{H2OModel} object}

\item{newdata}{An H2OFrame. The model will make predictions
on this dataset, and subsequently score them. The dataset should
match the dataset that was used to train the model, in terms of
column names, types, and dimensions. If newdata is passed in, then train, valid, and xval are ignored.}

\item{train}{A logical value indicating whether to return the training metrics (constructed during training).

Note: when the trained h2o model uses balance_classes, the training metrics constructed during training will be from the balanced training dataset.
For more information visit: \url{https://github.com/h2oai/h2o-3/discussions/15518}}

\item{valid}{A logical value indicating whether to return the validation metrics (constructed during training).}

\item{xval}{A logical value indicating whether to return the cross-validation metrics (constructed during training).}

\item{data}{(DEPRECATED) An H2OFrame. This argument is now called `newdata`.}

\item{auc_type}{For multinomila model only. Set default multinomial AUC type. Must be one of: "AUTO", "NONE", "MACRO_OVR", "WEIGHTED_OVR", "MACRO_OVO",
"WEIGHTED_OVO". Default is "NONE"}
}
\value{
Returns an object of the \linkS4class{H2OModelMetrics} subclass.
}
\description{
Given a trained h2o model, compute its performance on the given
dataset.  However, if the dataset does not contain the response/target column, no performance will be returned.
Instead, a warning message will be printed.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$CAPSULE <- as.factor(prostate$CAPSULE)
prostate_gbm <- h2o.gbm(3:9, "CAPSULE", prostate)
h2o.performance(model = prostate_gbm, newdata=prostate)

## If model uses balance_classes
## the results from train = TRUE will not match the results from newdata = prostate
prostate_gbm_balanced <- h2o.gbm(3:9, "CAPSULE", prostate, balance_classes = TRUE)
h2o.performance(model = prostate_gbm_balanced, newdata = prostate)
h2o.performance(model = prostate_gbm_balanced, train = TRUE)
}
}
