% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{is_rc3}
\alias{is_rc3}
\title{check if H3 cell index is in a Class III resolution}
\usage{
is_rc3(h3_address = NULL, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a logical vector of \code{length(h3_address)}.
}
\description{
This function checks whether a H3 cell index is in a Class III resolution
(rotated versus the icosahedron and subject to shape distortion adding extra
points on icosahedron edges).
}
\examples{
# is the following cell index Class III?
is_rc3(h3_address = '8abe8d12acaffff')
}
