% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspection.R
\name{getIcosahedronFaces}
\alias{getIcosahedronFaces}
\title{Get Icosahedron Faces}
\usage{
getIcosahedronFaces(cell)
}
\arguments{
\item{cell}{vector of H3 cells}
}
\value{
list of vectors. Each list element corresponds to the input \code{cell} values.
Each vector in a list element gives the faces intersected by the \code{cell}
}
\description{
Find all icosahedron faces intersected by a given H3 index.
Faces are represented as integers from 0-19, inclusive.
The array is sparse, and empty (no intersection) array values are
represented by -1.
}
\examples{
getIcosahedronFaces(cell = c("8cbe63562a54bff","8cbe635631103ff"))

getIcosahedronFaces(cell = cellToParent(c("8cbe63562a54bff" ,"8cbe635631103ff"), c(7L, 7L)))

}
