% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hack_cinsarc.R
\name{hack_cinsarc}
\alias{hack_cinsarc}
\title{Hack the CINSARC classification}
\source{
\href{https://codeocean.com/capsule/4933686/tree/v4}{codeocean.com/capsule/4933686/tree/v4}
}
\usage{
hack_cinsarc(expr_data, dm_status)
}
\arguments{
\item{expr_data}{A normalized gene expression matrix (or data frame) with
gene symbols as row names and samples as columns.}

\item{dm_status}{A numeric vector specifying whether a sample has either (1)
or not (0) developed distant metastasis.}
}
\value{
A tibble with one row for each sample in \code{expr_data} and two columns:
\code{sample_id} and \code{cinsarc_class}.
}
\description{
Given a gene expression matrix and a 0-1 vector indicating the distant metastasis
status of samples, \code{hack_cinsarc()} classifies samples into one of two risk
classes, C1 or C2, using the CINSARC signature as implemented in
\emph{Chibon et al., 2010}.
}
\details{
CINSARC (\emph{Complexity INdex in SARComas}) is a prognostic 67-gene signature
related to mitosis and control of chromosome integrity.
It was developed to improve metastatic outcome prediction in soft tissue
sarcomas over the FNCLCC (\emph{Fédération Francaise des Centres de Lutte Contre
le Cancer}) grading system.
}
\section{Algorithm}{

The CINSARC method implemented in \code{hacksig} makes use of leave-one-out cross
validation (LOOCV) to classify samples into C1/C2 risk groups (see \emph{Lesluyes & Chibon, 2020}).
First, gene expression values are centered by their mean across samples.
Then, for each iteration of the LOOCV, mean normalized gene values are computed
by metastasis group (i.e. compute the metastatic centroids). Then, one minus the
Spearman's correlation between centered samples and metastatic centroids are computed.
Finally, if a sample is more correlated to the non-metastatic centroid, then
it is assigned to the C1 class (low risk). Conversely, if a sample is more
correlated to the metastatic centroid, then it is assigned to the C2 class (high risk).
}

\examples{
# generate random distant metastasis outcome
set.seed(123)
test_dm_status <- sample(c(0, 1), size = ncol(test_expr), replace = TRUE)

hack_cinsarc(test_expr, test_dm_status)
}
\references{
Chibon, F., Lagarde, P., Salas, S., Pérot, G., Brouste, V., Tirode, F.,
Lucchesi, C., de Reynies, A., Kauffmann, A., Bui, B., Terrier, P.,
Bonvalot, S., Le Cesne, A., Vince-Ranchère, D., Blay, J. Y., Collin, F.,
Guillou, L., Leroux, A., Coindre, J. M., & Aurias, A. (2010). Validated
prediction of clinical outcome in sarcomas and multiple types of cancer on
the basis of a gene expression signature related to genome complexity.
\emph{Nature medicine}, 16(7), 781–787. \doi{10.1038/nm.2174}.

Lesluyes, T., & Chibon, F. (2020). A Global and Integrated
Analysis of CINSARC-Associated Genetic Defects. \emph{Cancer research}, 80(23),
5282–5290. \doi{10.1158/0008-5472.CAN-20-0512}.
}
