% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hankel.R
\name{bootstrap.hankel_summed}
\alias{bootstrap.hankel_summed}
\title{GEVP method based on Hankel matrices.}
\usage{
bootstrap.hankel_summed(cf, t0values = c(1:(N - 2 * n - deltat)),
  deltat = 1, n = 2, N = cf$Time/2 + 1)
}
\arguments{
\item{cf}{object of type \link{cf}}

\item{t0values}{Integer vector. The t0 values to sum over. Default is \code{c(1:max)}.
All elements must be larger or equal to zero and smaller or equal than
\code{max=N-2*n-deltat}}

\item{deltat}{Integer. value of deltat used in the hankel GEVP. Default is 1.}

\item{n}{Integer. Size of the Hankel matrices to generate, default is 2.}

\item{N}{Integer. Maximal time index in correlation function to be used in
Hankel matrix}
}
\value{
List object of class "hankel.summed". The eigenvalues are stored in a
numeric vector \code{t0}, the corresonding samples in \code{t}. The reference input
times \code{t0values} is stored as \code{t0values} in the returned list. In addition,
\code{deltat} is stored in the returned list.
}
\description{
Alternative method to determine energy levels from correlation
matrices. A so-called Hankel matrix is generated from an input
\link{cf} object and a generalised eigenvalue problem is solved
then. This is the function to call. It will perform a bootstrap
analysis.
}
\details{
See \code{vignette(name="hankel", package="hadron")}
}
\examples{

data(correlatormatrix)
correlatormatrix <- bootstrap.cf(correlatormatrix, boot.R=99, boot.l=1, seed=132435)
t0 <- 4
correlatormatrix.gevp <- bootstrap.gevp(cf=correlatormatrix, t0=t0, element.order=c(1,2,3,4))
pc1 <- gevp2cf(gevp=correlatormatrix.gevp, id=1)
pc1.hankel <- bootstrap.hankel_summed(cf=pc1, t0=c(1:15), n=2)
}
\seealso{
Other hankel: 
\code{\link{bootstrap.hankel}()},
\code{\link{gevp.hankel_summed}()},
\code{\link{gevp.hankel}()},
\code{\link{hankel2cf}()},
\code{\link{hankel2effectivemass}()},
\code{\link{plot_hankel_spectrum}()}
}
\concept{hankel}
