% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{plot_timeseries}
\alias{plot_timeseries}
\title{plot_timeseries}
\usage{
plot_timeseries(dat, ylab, plotsize, titletext, hist.by, stat_range = c(1,
  length(dat$y)), pdf.filename, name = "", xlab = "$t_\\\\mathrm{MD}$",
  hist.probs = c(0, 1), errorband_color = rgb(0.6, 0, 0, 0.6),
  type = "l", uwerr.S = 2, smooth_density = FALSE, periodogram = FALSE,
  debug = FALSE, uw.summary = TRUE, ...)
}
\arguments{
\item{dat}{Timeseries to analyse.}

\item{ylab}{Y-axis label.}

\item{plotsize}{Width and Height of plot.}

\item{titletext}{Text in the plot title.}

\item{hist.by}{Numeric. Stepping to compute the histogram breaks.}

\item{stat_range}{Optional integer vector of length 2. Start and end indices
of the subset of \code{dat} to be plotted. If left empty, all of \code{dat} will be
plotted.}

\item{pdf.filename}{String. PDF filename.}

\item{name}{String. Timeseries name.}

\item{xlab}{X-axis label.}

\item{hist.probs}{Optional numeric vector of length 2. Probability extrema to limit the width
of the histogram or smoothed density plots. By default all data is used. Note: this
has not effect on the analysis as a whole or other plots.}

\item{errorband_color}{String. Colour of the error band.}

\item{type}{String. Plot type, see \link{plot} for details.}

\item{uwerr.S}{Numeric. \code{S} of the \link{uwerr} method to be used.}

\item{smooth_density}{Boolean. Instead of plotting a histogram, use a smoothed density.}

\item{periodogram}{Boolean. Whether to show a periodogram.}

\item{debug}{Boolean. Generate debug output.}

\item{uw.summary}{Boolean. Generate an \link{uwerr} summary plot.}

\item{...}{Generic graphical parameters to be passed on.}
}
\value{
Returns a \link{data.frame} with named columns \code{val}, \code{dval}, \code{tauint}, \code{dtauint}, \code{Wopt}
and \code{stringsAsFactors}, see \link{uwerr}.
}
\description{
function to plot timeseries data, a corresponding histogram
and an error shading for an error analysis via uwerr
}
