% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readutils.R
\name{readbinarydisc}
\alias{readbinarydisc}
\title{read disconnected loops from binary files}
\usage{
readbinarydisc(files, Time = 48, obs = 5, endian = "little",
  excludelist = c(""), nrSamples = 1, path = "")
}
\arguments{
\item{files}{list of filenames to be read. Can be created for instance using
\code{getorderedfilelist}. The filelist is assumed to be ordered with number
of samples running fastest, and the next to fastest nubmer of gauges.}

\item{Time}{time extent of correlation functions.}

\item{obs}{each file may contain Time*obs correlation functions. With
\code{obs} one choses which observable to read in.}

\item{endian}{the endianess of the binary file.}

\item{excludelist}{files to exclude from reading.}

\item{nrSamples}{the number of samples}

\item{path}{path to be prepended to every filename.}
}
\value{
returns a list with two arrays \code{cf} and \code{icf} with real
and imaginary parts of the loops, and integers \code{Time},
\code{nrStypes=1}, \code{nrSamples} and \code{nrObs=1}. Both of the arrays
have dimension \code{c(Time, N)}, where \code{N} is the number of measurements
(gauges) and \code{Time} the time extent, \code{nrStypes} the number of smearing
levels and \code{nrObs} the number of operators, both of which are currently fixed to 1.
}
\description{
Reads disconnected loops from binary files.
}
\details{
It is assumend that each file contains O*Time complex doubles, where Time is the
time extent and O the number of observables in the file. It is assumed that
complex is the fastest running index, next time and then observables. The
different samples are assumend to be in different files. The file list is
assumed to be ordered with number of samples running fastest, and then
number of gauges.
}
\examples{

## running toy example
file <- paste0(system.file("extdata", package = "hadron"), "/C2_pi0.dat")
X <- readbinarydisc(files=file, Time=64, obs=0)
X$cf

## more realistic example
\dontrun{files <- character()}
\dontrun{for(i in seq(600,1744,8)) }
\dontrun{  files <- c(files, "C2_dis_u_conf", sprintf("\%.04d", i), ".dat", sep="")}
\dontrun{cf <- readbinarydisc(files, obs=4, excludelist=c("C2_pi0_conf0632.dat"))}

}
\seealso{
\code{\link{readcmidatafiles}}, \code{\link{readbinarycf}},
\code{\link{readcmidisc}}, \code{\link{readcmicor}}
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
\keyword{file}
