% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThinText.R
\name{readPNGBinary}
\alias{readPNGBinary}
\title{Read PNG Binary}
\usage{
readPNGBinary(
  path,
  cutoffAdjust = 0,
  clean = TRUE,
  crop = TRUE,
  inversion = FALSE
)
}
\arguments{
\item{path}{File path for image.}

\item{cutoffAdjust}{Multiplicative adjustment to the K-means estimated binarization cutoff.}

\item{clean}{Whether to fill in white pixels with 7 or 8 neighbors. This will help a lot when thinning -- keeps from getting little white bubbles in text.}

\item{crop}{Logical value dictating whether or not to crop the white out around the image. TRUE by default.}

\item{inversion}{Logical value dictating whether or not to flip each pixel of binarized image. Flipping happens after binarization. FALSE by default.}
}
\value{
Returns image from path. 0 represents black, and 1 represents white by default.
}
\description{
This function reads in and binarizes a PNG image.
}
\examples{
image_path <- system.file("extdata", "phrase_example.png", package = "handwriter")
csafe_document <- list()
csafe_document$image = readPNGBinary(image_path)
plotImage(csafe_document)

}
