% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bills.R
\name{bills}
\alias{bills}
\alias{bill_stage_types}
\title{bills}
\usage{
bills(ID = NULL, amendments = FALSE, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE)

bill_stage_types(tidy = TRUE)
}
\arguments{
\item{ID}{The ID of a given bill to return data on. If NULL, returns all bills, subject to other parameters. Defaults to NULL.}

\item{amendments}{If TRUE, returns all bills with amendments. Defaults to FALSE.}

\item{start_date}{The earliest date to include in the data frame. Defaults to '1900-01-01'.}

\item{end_date}{The latest date to include in the data frame. Defaults to current system date.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Imports data on House of Commons and House of Lords bills

Returns a data frames with all possible bill stage types.
}
\examples{
\dontrun{

x <- bills()

x <- bills(amendments=TRUE)

x <- bills(1719)


}
\dontrun{
x <- bill_stage_types()
}

}
\keyword{bills}
