% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hash.R
\name{hash}
\alias{hash}
\alias{hash.character}
\alias{hash.default}
\alias{hash.list}
\title{Hash R objects to 32bit integers}
\usage{
hash(x, ...)

\method{hash}{default}(x, ...)

\method{hash}{character}(x, recursive = TRUE,
  nthread = getOption("hashr_num_thread"), ...)

\method{hash}{list}(x, recursive = TRUE,
  nthread = getOption("hashr_num_thread"), ...)
}
\arguments{
\item{x}{Object to hash}

\item{...}{Arguments to be passed to other methods. In particular, for the default method,
 these arguments are passed to \code{\link[base]{serialize}}.}

\item{recursive}{hash each element separately?}

\item{nthread}{maximum number of threads used.}
}
\description{
Hash R objects to 32bit integers




}
\section{Details}{

The default method \code{\link[base]{serialize}}s the input to a single
\code{\link[base]{raw}} vector which is then hashed to a single signed
integer. This is also true for \code{character} vectors when
\code{recursive=FALSE}. When \code{recursive=TRUE} each element of a
\code{character} vector is hashed separately, based on the underlying
\code{char} representation in \code{C}.
}

\section{Parallelization}{

On systems supporting openMP, this function is able to use multiple cores.
By default, a sensible number of cores is chosen. See the entry on
\href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#OpenMP-support}{OpenMP Support} in the writing R extensions manual to check whether your system supports it.
}

\section{Hash function}{

The hash function used is Paul Hsieh's' \code{SuperFastHash} function which is
described on his \href{http://www.azillionmonkeys.com/qed/hash.html}{website}.
As the title of the algorithm suggests, this hashing algorithm is not aimed to
be used as a secure hash, and it is probably a bad idea to use it for that purpose.
}
\examples{

# hash some complicated R object (not a list).
m <- lm(height ~ weight, data=women)
hash(m)

# hash a character vector element by element:
x <- c("Call any vegetable"
     , "and the chances are good"
     , "that the vegetable will respond to you")
hash(x)

# hash a character vector as one object:
hash(x, recursive=FALSE)

# hash a list recursively
L <- strsplit(x," ")
hash(L)

# recursive really means recursive, so nested lists are recursed over:
L <- list(
  x = 10
  , y = list(
    foo = "bob"
    , bar = lm(Sepal.Width ~ Sepal.Length, data=iris)
  )
)

hash(L)
hash(L,recursive=FALSE)




}

