% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/haven.R
\name{read_dta}
\alias{read_dta}
\alias{read_stata}
\alias{write_dta}
\title{Read and write Stata DTA files.}
\usage{
read_dta(path)

read_stata(path)

write_dta(data, path)
}
\arguments{
\item{path}{Path to data. When reading data, if the path is a URL, the file
will be first downloaded to a temporary location before reading.}

\item{data}{Data frame to write.}
}
\value{
A data frame with additional "tbl_df" and "tbl" classes, which
  improve printing if dplyr is loaded.

  Variable labels are stored in the "label" attribute of each variable.
  It is not printed on the console, but the RStudio viewer will show it.
}
\description{
Currently haven can read and write logical, integer, numeric, character
and factors. See \code{\link{labelled}} for how labelled variables in
Stata are handled in R.
}
\examples{
tmp <- tempfile(fileext = ".dta")
write_dta(mtcars, tmp)
read_dta(tmp)
read_stata(tmp)
}

