#line 1 "src/txt/readstat_spss_commands_read.rl"
#include <stdlib.h>
#include <inttypes.h>

#include "../readstat.h"
#include "../readstat_strings.h"
#include "readstat_schema.h"

#include "readstat_copy.h"
#include "commands_util.h"


#line 14 "src/txt/readstat_spss_commands_read.c"
static const signed char _spss_commands_actions[] = {
	0, 1, 1, 1, 2, 1, 4, 1,
	8, 1, 12, 1, 13, 1, 15, 1,
	16, 1, 17, 1, 18, 1, 19, 1,
	20, 1, 21, 1, 22, 1, 27, 1,
	30, 1, 31, 1, 32, 1, 34, 2,
	0, 1, 2, 1, 0, 2, 2, 28,
	2, 2, 29, 2, 3, 28, 2, 3,
	29, 2, 4, 9, 2, 4, 12, 2,
	4, 14, 2, 4, 20, 2, 8, 20,
	2, 15, 16, 2, 17, 18, 2, 19,
	13, 2, 19, 20, 2, 21, 6, 2,
	21, 7, 2, 21, 12, 2, 21, 20,
	2, 23, 8, 2, 24, 8, 2, 25,
	8, 2, 26, 8, 3, 4, 0, 1,
	3, 4, 14, 13, 3, 4, 35, 5,
	3, 19, 0, 1, 3, 19, 8, 20,
	3, 21, 0, 1, 3, 21, 1, 0,
	3, 21, 6, 11, 3, 21, 12, 6,
	3, 33, 0, 1, 4, 19, 33, 0,
	1, 4, 21, 6, 10, 11, 4, 21,
	6, 11, 10, 0
};

static const short _spss_commands_key_offsets[] = {
	0, 0, 1, 2, 7, 9, 10, 11,
	13, 14, 15, 16, 17, 18, 19, 20,
	21, 25, 27, 29, 35, 41, 47, 48,
	50, 52, 54, 58, 68, 78, 79, 81,
	85, 87, 92, 97, 98, 108, 118, 119,
	120, 121, 126, 137, 148, 149, 155, 163,
	171, 172, 183, 189, 195, 196, 203, 212,
	221, 222, 226, 229, 233, 241, 249, 250,
	261, 267, 273, 274, 283, 294, 305, 306,
	310, 313, 319, 329, 339, 340, 344, 346,
	350, 356, 362, 363, 365, 367, 369, 371,
	375, 381, 387, 388, 390, 392, 394, 396,
	398, 400, 405, 410, 411, 413, 415, 417,
	419, 421, 425, 427, 429, 433, 439, 445,
	446, 448, 450, 452, 454, 456, 460, 468,
	476, 477, 488, 493, 498, 499, 503, 515,
	520, 525, 526, 538, 550, 551, 552, 553,
	559, 565, 571, 572, 573, 574, 582, 595,
	597, 599, 601, 603, 605, 609, 617, 625,
	626, 637, 646, 655, 656, 657, 659, 662,
	664, 667, 672, 678, 684, 685, 687, 689,
	693, 701, 709, 710, 712, 714, 716, 720,
	725, 730, 731, 737, 749, 754, 759, 760,
	772, 784, 785, 786, 787, 793, 799, 805,
	806, 807, 808, 816, 829, 843, 857, 871,
	885, 899, 913, 927, 941, 953, 958, 963,
	964, 976, 988, 989, 1002, 1014, 1026, 1027,
	1031, 1039, 1049, 1059, 1060, 1071, 1081, 1091,
	1092, 1094, 1096, 1098, 1100, 1108, 1110, 1118,
	1126, 1128, 1130, 1132, 1134, 1136, 1138, 1140,
	1142, 1144, 1148, 1154, 1160, 1161, 1163, 1165,
	1167, 1169, 1171, 1175, 1183, 1191, 1192, 1203,
	1208, 1213, 1214, 1216, 1217, 1218, 1219, 1224,
	1233, 1242, 1243, 1244, 1245, 1247, 1249, 1251,
	1253, 1255, 1259, 1267, 1275, 1276, 1287, 1292,
	1297, 1298, 1301, 1303, 1311, 1318, 1325, 1326,
	1328, 1335, 1340, 1345, 1346, 1347, 1348, 1349,
	1350, 1351, 1356, 1361, 1362, 1366, 1368, 1370,
	1374, 1382, 1390, 1391, 1393, 1395, 1397, 1399,
	1401, 1403, 1405, 1407, 1409, 1416, 1423, 1424,
	1425, 1426, 1432, 1438, 1444, 1445, 1450, 1455,
	1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463,
	1464, 1465, 1472, 1479, 1480, 1481, 1482, 1488,
	1494, 1495, 1497, 1499, 1501, 1503, 1505, 1507,
	1511, 1513, 1515, 1517, 1521, 1527, 1533, 1534,
	1536, 1540, 1555, 1571, 1587, 1588, 1589, 1590,
	1606, 1607, 1608, 1610, 1626, 1643, 1660, 1675,
	1676, 1680, 1688, 1696, 1697, 1709, 1714, 1719,
	1720, 1732, 1744, 1745, 1746, 1747, 1752, 1753,
	1754, 1761, 1773, 1775, 1779, 1781, 1783, 1787,
	1793, 1799, 1800, 1802, 1804, 1806, 1808, 1810,
	1814, 1823, 1832, 1833, 1841, 1849, 1850, 1861,
	1875, 1889, 1890, 1891, 1892, 1896, 1902, 1908,
	1909, 1910, 1911, 1917, 1928, 1939, 1940, 1941,
	1942, 1944, 1950, 1961, 1972, 1973, 1986, 1999,
	2012, 2025, 2038, 2051, 2064, 2075, 2091, 2107,
	2108, 2112, 2118, 2125, 2132, 2133, 2134, 2135,
	2139, 2145, 2151, 2152, 2158, 2169, 2182, 2195,
	2208, 2221, 2232, 2246, 2260, 2261, 2272, 2287,
	2302, 2303, 2309, 2311, 2313, 2315, 2317, 2319,
	2321, 2322, 2328, 2334, 2335, 2343, 2351, 2352,
	2363, 2372, 2381, 2382, 2393, 2395, 2397, 2399,
	2401, 2403, 2405, 2416, 2418, 2420, 2422, 2424,
	2426, 2430, 2436, 2442, 2443, 2445, 2447, 2449,
	2451, 2457, 2465, 2473, 2474, 2485, 2491, 2497,
	2498, 2499, 2500, 2506, 2516, 2526, 2527, 2532,
	2541, 2550, 2551, 2552, 2553, 2557, 2559, 2561,
	2563, 2565, 2573, 2575, 2577, 2579, 2586, 2593,
	2594, 2600, 2606, 2607, 2610, 2616, 2619, 2625,
	2631, 2632, 2640, 2643, 2647, 2650, 2656, 2662,
	2663, 2669, 2675, 2677, 2679, 2681, 2683, 2685,
	2692, 2697, 2702, 2703, 2709, 2715, 2716, 2723,
	2725, 2727, 2729, 2731, 2736, 2737, 2738, 2750,
	2752, 2754, 2756, 2758, 2762, 2768, 2774, 2775,
	2777, 2779, 2781, 2785, 2795, 2805, 2806, 2807,
	2808, 2813, 2819, 2825, 2826, 2828, 2830, 2832,
	2834, 2836, 2841, 2846, 2847, 2855, 2863, 2864,
	2876, 2877, 2878, 2880, 2882, 2884, 2886, 2888,
	2893, 2902, 2911, 2912, 2924, 2951, 2978, 3005,
	0
};

static const char _spss_commands_trans_keys[] = {
	10, 46, 9, 10, 13, 32, 46, 10,
	46, 42, 42, 42, 47, 79, 77, 77,
	69, 78, 84, 32, 46, 65, 73, 97,
	105, 84, 116, 65, 97, 9, 10, 13,
	32, 83, 115, 9, 10, 13, 32, 76,
	108, 9, 10, 13, 32, 76, 108, 10,
	73, 105, 83, 115, 84, 116, 9, 10,
	13, 32, 9, 10, 13, 32, 70, 82,
	84, 102, 114, 116, 9, 10, 13, 32,
	70, 82, 84, 102, 114, 116, 10, 73,
	105, 76, 88, 108, 120, 69, 101, 9,
	10, 13, 32, 61, 9, 10, 13, 32,
	61, 10, 9, 10, 13, 32, 34, 39,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 65, 90, 97, 122, 10, 34,
	34, 9, 10, 13, 32, 47, 9, 10,
	13, 32, 47, 70, 82, 84, 102, 114,
	116, 9, 10, 13, 32, 47, 70, 82,
	84, 102, 114, 116, 10, 9, 10, 13,
	32, 48, 57, 9, 10, 13, 32, 65,
	90, 97, 122, 9, 10, 13, 32, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 48, 57, 9, 10, 13,
	32, 48, 57, 10, 9, 10, 13, 32,
	45, 48, 57, 9, 10, 13, 32, 40,
	65, 90, 97, 122, 9, 10, 13, 32,
	40, 65, 90, 97, 122, 10, 65, 97,
	48, 57, 41, 48, 57, 9, 10, 13,
	32, 9, 10, 13, 32, 65, 90, 97,
	122, 9, 10, 13, 32, 65, 90, 97,
	122, 10, 9, 10, 13, 32, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 48, 57, 9, 10, 13, 32, 48,
	57, 10, 9, 10, 13, 32, 45, 46,
	47, 48, 57, 9, 10, 13, 32, 40,
	46, 47, 65, 90, 97, 122, 9, 10,
	13, 32, 40, 46, 47, 65, 90, 97,
	122, 10, 65, 97, 48, 57, 41, 48,
	57, 9, 10, 13, 32, 46, 47, 9,
	10, 13, 32, 46, 47, 65, 90, 97,
	122, 9, 10, 13, 32, 46, 47, 65,
	90, 97, 122, 10, 78, 88, 110, 120,
	68, 100, 9, 10, 13, 32, 9, 10,
	13, 32, 73, 105, 9, 10, 13, 32,
	73, 105, 10, 78, 110, 80, 112, 85,
	117, 84, 116, 9, 10, 13, 32, 9,
	10, 13, 32, 80, 112, 9, 10, 13,
	32, 80, 112, 10, 82, 114, 79, 111,
	71, 103, 82, 114, 65, 97, 77, 109,
	9, 10, 13, 32, 46, 9, 10, 13,
	32, 46, 10, 69, 101, 67, 99, 85,
	117, 84, 116, 69, 101, 73, 79, 105,
	111, 76, 108, 69, 101, 9, 10, 13,
	32, 9, 10, 13, 32, 72, 104, 9,
	10, 13, 32, 72, 104, 10, 65, 97,
	78, 110, 68, 100, 76, 108, 69, 101,
	9, 10, 13, 32, 9, 10, 13, 32,
	65, 90, 97, 122, 9, 10, 13, 32,
	65, 90, 97, 122, 10, 9, 10, 13,
	32, 95, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 47, 9, 10, 13,
	32, 47, 10, 65, 90, 97, 122, 9,
	10, 13, 32, 61, 95, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 61,
	9, 10, 13, 32, 61, 10, 9, 10,
	13, 32, 34, 39, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	48, 57, 65, 90, 97, 122, 10, 34,
	34, 9, 10, 13, 32, 46, 47, 9,
	10, 13, 32, 46, 47, 9, 10, 13,
	32, 46, 47, 10, 39, 39, 9, 10,
	13, 32, 46, 47, 48, 57, 9, 10,
	13, 32, 46, 47, 95, 48, 57, 65,
	90, 97, 122, 82, 114, 77, 109, 65,
	97, 84, 116, 83, 115, 9, 10, 13,
	32, 9, 10, 13, 32, 65, 90, 97,
	122, 9, 10, 13, 32, 65, 90, 97,
	122, 10, 9, 10, 13, 32, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 40, 65, 90, 97, 122, 9, 10,
	13, 32, 40, 65, 90, 97, 122, 10,
	70, 48, 57, 46, 48, 57, 48, 57,
	41, 48, 57, 9, 10, 13, 32, 46,
	9, 10, 13, 32, 46, 47, 9, 10,
	13, 32, 46, 47, 10, 69, 101, 84,
	116, 9, 10, 13, 32, 9, 10, 13,
	32, 68, 70, 100, 102, 9, 10, 13,
	32, 68, 70, 100, 102, 10, 65, 97,
	84, 116, 65, 97, 9, 10, 13, 32,
	9, 10, 13, 32, 47, 9, 10, 13,
	32, 47, 10, 86, 118, 65, 90, 97,
	122, 9, 10, 13, 32, 61, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 61, 9, 10, 13, 32, 61, 10,
	9, 10, 13, 32, 34, 39, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 48, 57, 65, 90, 97, 122,
	10, 34, 34, 9, 10, 13, 32, 46,
	47, 9, 10, 13, 32, 46, 47, 9,
	10, 13, 32, 46, 47, 10, 39, 39,
	9, 10, 13, 32, 46, 47, 48, 57,
	9, 10, 13, 32, 46, 47, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 61, 65, 95, 97, 48, 57, 66,
	90, 98, 122, 9, 10, 13, 32, 61,
	82, 95, 114, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 61, 73, 95,
	105, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 61, 65, 95, 97, 48,
	57, 66, 90, 98, 122, 9, 10, 13,
	32, 61, 66, 95, 98, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 61,
	76, 95, 108, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 61, 69, 95,
	101, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 61, 83, 95, 115, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 61, 95, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 61, 9, 10,
	13, 32, 61, 10, 9, 10, 13, 32,
	34, 39, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 34, 39, 48, 57,
	65, 90, 97, 122, 10, 9, 10, 13,
	32, 46, 47, 95, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 46, 47,
	65, 68, 70, 97, 100, 102, 9, 10,
	13, 32, 46, 47, 65, 68, 70, 97,
	100, 102, 10, 68, 100, 48, 57, 9,
	10, 13, 32, 46, 47, 48, 57, 9,
	10, 13, 32, 46, 47, 65, 90, 97,
	122, 9, 10, 13, 32, 46, 47, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 65, 68, 70, 97, 100,
	102, 9, 10, 13, 32, 65, 68, 70,
	97, 100, 102, 10, 65, 97, 84, 116,
	69, 101, 48, 57, 9, 10, 13, 32,
	46, 47, 48, 57, 48, 57, 9, 10,
	13, 32, 46, 47, 48, 57, 9, 10,
	13, 32, 46, 47, 48, 57, 73, 105,
	83, 115, 84, 116, 73, 105, 83, 115,
	83, 115, 73, 105, 78, 110, 71, 103,
	9, 10, 13, 32, 9, 10, 13, 32,
	86, 118, 9, 10, 13, 32, 86, 118,
	10, 65, 97, 76, 108, 85, 117, 69,
	101, 83, 115, 9, 10, 13, 32, 9,
	10, 13, 32, 65, 90, 97, 122, 9,
	10, 13, 32, 65, 90, 97, 122, 10,
	9, 10, 13, 32, 95, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 40,
	9, 10, 13, 32, 40, 10, 34, 39,
	34, 34, 41, 9, 10, 13, 32, 46,
	9, 10, 13, 32, 46, 65, 90, 97,
	122, 9, 10, 13, 32, 46, 65, 90,
	97, 122, 10, 39, 39, 69, 101, 67,
	99, 79, 111, 68, 100, 69, 101, 9,
	10, 13, 32, 9, 10, 13, 32, 65,
	90, 97, 122, 9, 10, 13, 32, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 40, 9, 10, 13, 32,
	40, 10, 45, 48, 57, 48, 57, 9,
	10, 13, 32, 46, 61, 48, 57, 9,
	10, 13, 32, 45, 48, 57, 9, 10,
	13, 32, 45, 48, 57, 10, 48, 57,
	9, 10, 13, 32, 61, 48, 57, 9,
	10, 13, 32, 83, 9, 10, 13, 32,
	83, 10, 89, 83, 77, 73, 83, 9,
	10, 13, 32, 41, 9, 10, 13, 32,
	41, 10, 65, 69, 97, 101, 86, 118,
	69, 101, 9, 10, 13, 32, 9, 10,
	13, 32, 68, 79, 100, 111, 9, 10,
	13, 32, 68, 79, 100, 111, 10, 73,
	105, 67, 99, 84, 116, 73, 105, 79,
	111, 78, 110, 65, 97, 82, 114, 89,
	121, 9, 10, 13, 32, 34, 39, 61,
	9, 10, 13, 32, 34, 39, 61, 10,
	34, 34, 9, 10, 13, 32, 46, 47,
	9, 10, 13, 32, 46, 47, 9, 10,
	13, 32, 46, 47, 10, 9, 10, 13,
	32, 67, 9, 10, 13, 32, 67, 10,
	79, 77, 80, 82, 69, 83, 83, 69,
	68, 9, 10, 13, 32, 46, 47, 67,
	9, 10, 13, 32, 46, 47, 67, 10,
	39, 39, 9, 10, 13, 32, 34, 39,
	9, 10, 13, 32, 34, 39, 10, 85,
	117, 84, 116, 70, 102, 73, 105, 76,
	108, 69, 101, 76, 84, 108, 116, 69,
	101, 67, 99, 84, 116, 9, 10, 13,
	32, 9, 10, 13, 32, 73, 105, 9,
	10, 13, 32, 73, 105, 10, 70, 102,
	9, 10, 13, 32, 9, 10, 13, 32,
	34, 39, 45, 40, 41, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 46, 40, 41, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 46, 40, 41, 48, 57, 65,
	90, 97, 122, 10, 34, 34, 9, 10,
	13, 32, 34, 39, 45, 46, 40, 41,
	48, 57, 65, 90, 97, 122, 39, 39,
	48, 57, 9, 10, 13, 32, 34, 39,
	45, 46, 40, 41, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 95, 40, 41, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 46, 95, 40, 41, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 45, 40, 41, 48, 57, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	9, 10, 13, 32, 65, 90, 97, 122,
	9, 10, 13, 32, 65, 90, 97, 122,
	10, 9, 10, 13, 32, 61, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 61, 9, 10, 13, 32, 61, 10,
	9, 10, 13, 32, 34, 39, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 48, 57, 65, 90, 97, 122,
	10, 34, 34, 9, 10, 13, 32, 46,
	39, 39, 9, 10, 13, 32, 46, 48,
	57, 9, 10, 13, 32, 46, 95, 48,
	57, 65, 90, 97, 122, 65, 97, 76,
	82, 108, 114, 85, 117, 69, 101, 9,
	10, 13, 32, 9, 10, 13, 32, 76,
	108, 9, 10, 13, 32, 76, 108, 10,
	65, 97, 66, 98, 69, 101, 76, 108,
	83, 115, 9, 10, 13, 32, 9, 10,
	13, 32, 47, 65, 90, 97, 122, 9,
	10, 13, 32, 47, 65, 90, 97, 122,
	10, 9, 10, 13, 32, 65, 90, 97,
	122, 9, 10, 13, 32, 65, 90, 97,
	122, 10, 9, 10, 13, 32, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 34, 39, 45, 46, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 46, 48, 57, 65, 90, 97,
	122, 10, 34, 34, 9, 10, 13, 32,
	9, 10, 13, 32, 34, 39, 9, 10,
	13, 32, 34, 39, 10, 34, 34, 9,
	10, 13, 32, 46, 47, 9, 10, 13,
	32, 34, 39, 45, 46, 47, 48, 57,
	9, 10, 13, 32, 34, 39, 45, 46,
	47, 48, 57, 10, 39, 39, 48, 57,
	9, 10, 13, 32, 48, 57, 9, 10,
	13, 32, 46, 86, 118, 65, 90, 97,
	122, 9, 10, 13, 32, 46, 86, 118,
	65, 90, 97, 122, 10, 9, 10, 13,
	32, 65, 95, 97, 48, 57, 66, 90,
	98, 122, 9, 10, 13, 32, 82, 95,
	114, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 73, 95, 105, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	65, 95, 97, 48, 57, 66, 90, 98,
	122, 9, 10, 13, 32, 66, 95, 98,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 76, 95, 108, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 69,
	95, 101, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 95, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 46, 76, 108, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 46, 76, 108, 48, 57, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	9, 10, 13, 32, 48, 57, 9, 10,
	13, 32, 34, 39, 45, 9, 10, 13,
	32, 34, 39, 45, 10, 39, 39, 9,
	10, 13, 32, 9, 10, 13, 32, 48,
	57, 9, 10, 13, 32, 48, 57, 10,
	9, 10, 13, 32, 48, 57, 9, 10,
	13, 32, 95, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 69, 95, 101,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 86, 95, 118, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 69,
	95, 101, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 76, 95, 108, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 95, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 34, 39, 45, 46,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 34, 39, 45, 46, 48, 57,
	65, 90, 97, 122, 10, 9, 10, 13,
	32, 95, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 34, 39, 40, 45,
	46, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 34, 39, 40, 45, 46,
	48, 57, 65, 90, 97, 122, 10, 78,
	79, 83, 110, 111, 115, 79, 111, 77,
	109, 73, 105, 78, 110, 65, 97, 76,
	108, 41, 9, 10, 13, 32, 46, 47,
	9, 10, 13, 32, 46, 47, 10, 9,
	10, 13, 32, 65, 90, 97, 122, 9,
	10, 13, 32, 65, 90, 97, 122, 10,
	9, 10, 13, 32, 95, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 40,
	65, 90, 97, 122, 9, 10, 13, 32,
	40, 65, 90, 97, 122, 10, 9, 10,
	13, 32, 95, 48, 57, 65, 90, 97,
	122, 82, 114, 68, 100, 67, 99, 65,
	97, 76, 108, 69, 101, 9, 10, 13,
	32, 95, 48, 57, 65, 90, 97, 122,
	73, 105, 65, 97, 66, 98, 76, 108,
	69, 101, 9, 10, 13, 32, 9, 10,
	13, 32, 76, 108, 9, 10, 13, 32,
	76, 108, 10, 65, 97, 66, 98, 69,
	101, 76, 108, 9, 10, 13, 32, 83,
	115, 9, 10, 13, 32, 65, 90, 97,
	122, 9, 10, 13, 32, 65, 90, 97,
	122, 10, 9, 10, 13, 32, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 34, 39, 9, 10, 13, 32, 34,
	39, 10, 34, 34, 9, 10, 13, 32,
	46, 47, 9, 10, 13, 32, 46, 47,
	65, 90, 97, 122, 9, 10, 13, 32,
	46, 47, 65, 90, 97, 122, 10, 9,
	10, 13, 32, 46, 9, 10, 13, 32,
	46, 65, 90, 97, 122, 9, 10, 13,
	32, 46, 65, 90, 97, 122, 10, 39,
	39, 9, 10, 13, 32, 65, 97, 84,
	116, 69, 101, 48, 57, 9, 10, 13,
	32, 46, 47, 48, 57, 73, 105, 76,
	108, 69, 101, 9, 10, 13, 32, 34,
	39, 61, 9, 10, 13, 32, 34, 39,
	61, 10, 9, 10, 13, 32, 34, 39,
	9, 10, 13, 32, 34, 39, 10, 41,
	48, 57, 9, 10, 13, 32, 46, 47,
	41, 48, 57, 9, 10, 13, 32, 48,
	57, 9, 10, 13, 32, 48, 57, 10,
	9, 10, 13, 32, 46, 47, 48, 57,
	41, 48, 57, 9, 10, 13, 32, 41,
	48, 57, 9, 10, 13, 32, 48, 57,
	9, 10, 13, 32, 48, 57, 10, 9,
	10, 13, 32, 48, 57, 9, 10, 13,
	32, 48, 57, 69, 101, 67, 99, 79,
	111, 82, 114, 68, 100, 9, 10, 13,
	32, 61, 83, 115, 9, 10, 13, 32,
	61, 9, 10, 13, 32, 61, 10, 9,
	10, 13, 32, 48, 57, 9, 10, 13,
	32, 48, 57, 10, 9, 10, 13, 32,
	47, 48, 57, 65, 97, 66, 98, 76,
	108, 69, 101, 9, 10, 13, 32, 47,
	39, 39, 9, 10, 13, 32, 47, 95,
	48, 57, 65, 90, 97, 122, 69, 101,
	68, 100, 69, 101, 84, 116, 9, 10,
	13, 32, 9, 10, 13, 32, 78, 110,
	9, 10, 13, 32, 78, 110, 10, 65,
	97, 77, 109, 69, 101, 9, 10, 13,
	32, 9, 10, 13, 32, 34, 39, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 65, 90, 97, 122, 10, 34, 34,
	9, 10, 13, 32, 46, 9, 10, 13,
	32, 87, 119, 9, 10, 13, 32, 87,
	119, 10, 73, 105, 78, 110, 68, 100,
	79, 111, 87, 119, 9, 10, 13, 32,
	61, 9, 10, 13, 32, 61, 10, 9,
	10, 13, 32, 65, 90, 97, 122, 9,
	10, 13, 32, 65, 90, 97, 122, 10,
	9, 10, 13, 32, 46, 95, 48, 57,
	65, 90, 97, 122, 39, 39, 83, 115,
	80, 112, 76, 108, 65, 97, 89, 121,
	9, 10, 13, 32, 46, 9, 10, 13,
	32, 46, 65, 90, 97, 122, 9, 10,
	13, 32, 46, 65, 90, 97, 122, 10,
	9, 10, 13, 32, 46, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	42, 47, 67, 68, 69, 70, 71, 73,
	76, 77, 82, 83, 86, 100, 101, 102,
	103, 105, 108, 109, 114, 115, 118, 9,
	10, 13, 32, 42, 47, 67, 68, 69,
	70, 71, 73, 76, 77, 82, 83, 86,
	100, 101, 102, 103, 105, 108, 109, 114,
	115, 118, 9, 10, 13, 32, 42, 47,
	67, 68, 69, 70, 71, 73, 76, 77,
	82, 83, 86, 100, 101, 102, 103, 105,
	108, 109, 114, 115, 118, 9, 10, 13,
	32, 42, 47, 67, 68, 69, 70, 71,
	73, 76, 77, 82, 83, 86, 100, 101,
	102, 103, 105, 108, 109, 114, 115, 118,
	48, 57, 0
};

static const signed char _spss_commands_single_lengths[] = {
	0, 1, 1, 5, 2, 1, 1, 2,
	1, 1, 1, 1, 1, 1, 1, 1,
	4, 2, 2, 6, 6, 6, 1, 2,
	2, 2, 4, 10, 10, 1, 2, 4,
	2, 5, 5, 1, 6, 6, 1, 1,
	1, 5, 11, 11, 1, 4, 4, 4,
	1, 5, 4, 4, 1, 5, 5, 5,
	1, 2, 1, 4, 4, 4, 1, 5,
	4, 4, 1, 7, 7, 7, 1, 2,
	1, 6, 6, 6, 1, 4, 2, 4,
	6, 6, 1, 2, 2, 2, 2, 4,
	6, 6, 1, 2, 2, 2, 2, 2,
	2, 5, 5, 1, 2, 2, 2, 2,
	2, 4, 2, 2, 4, 6, 6, 1,
	2, 2, 2, 2, 2, 4, 4, 4,
	1, 5, 5, 5, 1, 0, 6, 5,
	5, 1, 6, 6, 1, 1, 1, 6,
	6, 6, 1, 1, 1, 6, 7, 2,
	2, 2, 2, 2, 4, 4, 4, 1,
	5, 5, 5, 1, 1, 0, 1, 0,
	1, 5, 6, 6, 1, 2, 2, 4,
	8, 8, 1, 2, 2, 2, 4, 5,
	5, 1, 2, 6, 5, 5, 1, 6,
	6, 1, 1, 1, 6, 6, 6, 1,
	1, 1, 6, 7, 8, 8, 8, 8,
	8, 8, 8, 8, 6, 5, 5, 1,
	6, 6, 1, 7, 12, 12, 1, 2,
	6, 6, 6, 1, 5, 10, 10, 1,
	2, 2, 2, 0, 6, 0, 6, 6,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 4, 6, 6, 1, 2, 2, 2,
	2, 2, 4, 4, 4, 1, 5, 5,
	5, 1, 2, 1, 1, 1, 5, 5,
	5, 1, 1, 1, 2, 2, 2, 2,
	2, 4, 4, 4, 1, 5, 5, 5,
	1, 1, 0, 6, 5, 5, 1, 0,
	5, 5, 5, 1, 1, 1, 1, 1,
	1, 5, 5, 1, 4, 2, 2, 4,
	8, 8, 1, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 7, 7, 1, 1,
	1, 6, 6, 6, 1, 5, 5, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 7, 7, 1, 1, 1, 6, 6,
	1, 2, 2, 2, 2, 2, 2, 4,
	2, 2, 2, 4, 6, 6, 1, 2,
	4, 7, 8, 8, 1, 1, 1, 8,
	1, 1, 0, 8, 9, 9, 7, 1,
	4, 4, 4, 1, 6, 5, 5, 1,
	6, 6, 1, 1, 1, 5, 1, 1,
	5, 6, 2, 4, 2, 2, 4, 6,
	6, 1, 2, 2, 2, 2, 2, 4,
	5, 5, 1, 4, 4, 1, 5, 8,
	8, 1, 1, 1, 4, 6, 6, 1,
	1, 1, 6, 9, 9, 1, 1, 1,
	0, 4, 7, 7, 1, 7, 7, 7,
	7, 7, 7, 7, 5, 10, 10, 1,
	4, 4, 7, 7, 1, 1, 1, 4,
	4, 4, 1, 4, 5, 7, 7, 7,
	7, 5, 8, 8, 1, 5, 9, 9,
	1, 6, 2, 2, 2, 2, 2, 2,
	1, 6, 6, 1, 4, 4, 1, 5,
	5, 5, 1, 5, 2, 2, 2, 2,
	2, 2, 5, 2, 2, 2, 2, 2,
	4, 6, 6, 1, 2, 2, 2, 2,
	6, 4, 4, 1, 5, 6, 6, 1,
	1, 1, 6, 6, 6, 1, 5, 5,
	5, 1, 1, 1, 4, 2, 2, 2,
	0, 6, 2, 2, 2, 7, 7, 1,
	6, 6, 1, 1, 6, 1, 4, 4,
	1, 6, 1, 4, 1, 4, 4, 1,
	4, 4, 2, 2, 2, 2, 2, 7,
	5, 5, 1, 4, 4, 1, 5, 2,
	2, 2, 2, 5, 1, 1, 6, 2,
	2, 2, 2, 4, 6, 6, 1, 2,
	2, 2, 4, 6, 6, 1, 1, 1,
	5, 6, 6, 1, 2, 2, 2, 2,
	2, 5, 5, 1, 4, 4, 1, 6,
	1, 1, 2, 2, 2, 2, 2, 5,
	5, 5, 1, 6, 27, 27, 27, 27,
	0
};

static const signed char _spss_commands_range_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 2, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 2,
	0, 3, 1, 1, 0, 1, 2, 2,
	0, 1, 1, 0, 2, 2, 0, 3,
	1, 1, 0, 1, 2, 2, 0, 1,
	1, 0, 2, 2, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 2, 2,
	0, 3, 0, 0, 0, 2, 3, 0,
	0, 0, 3, 3, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 3, 0,
	0, 0, 0, 0, 0, 2, 2, 0,
	3, 2, 2, 0, 0, 1, 1, 1,
	1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 2, 3, 0, 0, 0, 3,
	3, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 0, 0,
	3, 3, 0, 3, 0, 0, 0, 1,
	1, 2, 2, 0, 3, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 2, 2, 0, 3, 0,
	0, 0, 0, 0, 0, 0, 0, 2,
	2, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 2, 2, 0, 3, 0, 0,
	0, 1, 1, 1, 1, 1, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 4, 4, 4, 0, 0, 0, 4,
	0, 0, 1, 4, 4, 4, 4, 0,
	0, 2, 2, 0, 3, 0, 0, 0,
	3, 3, 0, 0, 0, 0, 0, 0,
	1, 3, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	2, 2, 0, 2, 2, 0, 3, 3,
	3, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 0, 0, 0,
	1, 1, 2, 2, 0, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 0,
	0, 1, 0, 0, 0, 0, 0, 0,
	1, 1, 0, 1, 3, 3, 3, 3,
	3, 3, 3, 3, 0, 3, 3, 3,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 2, 0, 3,
	2, 2, 0, 3, 0, 0, 0, 0,
	0, 0, 3, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 2, 2, 0, 3, 0, 0, 0,
	0, 0, 0, 2, 2, 0, 0, 2,
	2, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 0, 1, 1, 1,
	0, 1, 1, 0, 1, 1, 1, 0,
	1, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 0, 1, 0,
	0, 0, 0, 0, 0, 0, 3, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 2, 2, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 2, 0, 3,
	0, 0, 0, 0, 0, 0, 0, 0,
	2, 2, 0, 3, 0, 0, 0, 1,
	0
};

static const short _spss_commands_index_offsets[] = {
	0, 0, 2, 4, 10, 13, 15, 17,
	20, 22, 24, 26, 28, 30, 32, 34,
	36, 41, 44, 47, 54, 61, 68, 70,
	73, 76, 79, 84, 95, 106, 108, 111,
	116, 119, 125, 131, 133, 142, 151, 153,
	155, 157, 163, 175, 187, 189, 195, 202,
	209, 211, 220, 226, 232, 234, 241, 249,
	257, 259, 263, 266, 271, 278, 285, 287,
	296, 302, 308, 310, 319, 329, 339, 341,
	345, 348, 355, 364, 373, 375, 380, 383,
	388, 395, 402, 404, 407, 410, 413, 416,
	421, 428, 435, 437, 440, 443, 446, 449,
	452, 455, 461, 467, 469, 472, 475, 478,
	481, 484, 489, 492, 495, 500, 507, 514,
	516, 519, 522, 525, 528, 531, 536, 543,
	550, 552, 561, 567, 573, 575, 578, 588,
	594, 600, 602, 612, 622, 624, 626, 628,
	635, 642, 649, 651, 653, 655, 663, 674,
	677, 680, 683, 686, 689, 694, 701, 708,
	710, 719, 727, 735, 737, 739, 741, 744,
	746, 749, 755, 762, 769, 771, 774, 777,
	782, 791, 800, 802, 805, 808, 811, 816,
	822, 828, 830, 835, 845, 851, 857, 859,
	869, 879, 881, 883, 885, 892, 899, 906,
	908, 910, 912, 920, 931, 943, 955, 967,
	979, 991, 1003, 1015, 1027, 1037, 1043, 1049,
	1051, 1061, 1071, 1073, 1084, 1097, 1110, 1112,
	1116, 1124, 1133, 1142, 1144, 1153, 1164, 1175,
	1177, 1180, 1183, 1186, 1188, 1196, 1198, 1206,
	1214, 1217, 1220, 1223, 1226, 1229, 1232, 1235,
	1238, 1241, 1246, 1253, 1260, 1262, 1265, 1268,
	1271, 1274, 1277, 1282, 1289, 1296, 1298, 1307,
	1313, 1319, 1321, 1324, 1326, 1328, 1330, 1336,
	1344, 1352, 1354, 1356, 1358, 1361, 1364, 1367,
	1370, 1373, 1378, 1385, 1392, 1394, 1403, 1409,
	1415, 1417, 1420, 1422, 1430, 1437, 1444, 1446,
	1448, 1455, 1461, 1467, 1469, 1471, 1473, 1475,
	1477, 1479, 1485, 1491, 1493, 1498, 1501, 1504,
	1509, 1518, 1527, 1529, 1532, 1535, 1538, 1541,
	1544, 1547, 1550, 1553, 1556, 1564, 1572, 1574,
	1576, 1578, 1585, 1592, 1599, 1601, 1607, 1613,
	1615, 1617, 1619, 1621, 1623, 1625, 1627, 1629,
	1631, 1633, 1641, 1649, 1651, 1653, 1655, 1662,
	1669, 1671, 1674, 1677, 1680, 1683, 1686, 1689,
	1694, 1697, 1700, 1703, 1708, 1715, 1722, 1724,
	1727, 1732, 1744, 1757, 1770, 1772, 1774, 1776,
	1789, 1791, 1793, 1795, 1808, 1822, 1836, 1848,
	1850, 1855, 1862, 1869, 1871, 1881, 1887, 1893,
	1895, 1905, 1915, 1917, 1919, 1921, 1927, 1929,
	1931, 1938, 1948, 1951, 1956, 1959, 1962, 1967,
	1974, 1981, 1983, 1986, 1989, 1992, 1995, 1998,
	2003, 2011, 2019, 2021, 2028, 2035, 2037, 2046,
	2058, 2070, 2072, 2074, 2076, 2081, 2088, 2095,
	2097, 2099, 2101, 2108, 2119, 2130, 2132, 2134,
	2136, 2138, 2144, 2154, 2164, 2166, 2177, 2188,
	2199, 2210, 2221, 2232, 2243, 2252, 2266, 2280,
	2282, 2287, 2293, 2301, 2309, 2311, 2313, 2315,
	2320, 2326, 2332, 2334, 2340, 2349, 2360, 2371,
	2382, 2393, 2402, 2414, 2426, 2428, 2437, 2450,
	2463, 2465, 2472, 2475, 2478, 2481, 2484, 2487,
	2490, 2492, 2499, 2506, 2508, 2515, 2522, 2524,
	2533, 2541, 2549, 2551, 2560, 2563, 2566, 2569,
	2572, 2575, 2578, 2587, 2590, 2593, 2596, 2599,
	2602, 2607, 2614, 2621, 2623, 2626, 2629, 2632,
	2635, 2642, 2649, 2656, 2658, 2667, 2674, 2681,
	2683, 2685, 2687, 2694, 2703, 2712, 2714, 2720,
	2728, 2736, 2738, 2740, 2742, 2747, 2750, 2753,
	2756, 2758, 2766, 2769, 2772, 2775, 2783, 2791,
	2793, 2800, 2807, 2809, 2812, 2819, 2822, 2828,
	2834, 2836, 2844, 2847, 2852, 2855, 2861, 2867,
	2869, 2875, 2881, 2884, 2887, 2890, 2893, 2896,
	2904, 2910, 2916, 2918, 2924, 2930, 2932, 2939,
	2942, 2945, 2948, 2951, 2957, 2959, 2961, 2971,
	2974, 2977, 2980, 2983, 2988, 2995, 3002, 3004,
	3007, 3010, 3013, 3018, 3027, 3036, 3038, 3040,
	3042, 3048, 3055, 3062, 3064, 3067, 3070, 3073,
	3076, 3079, 3085, 3091, 3093, 3100, 3107, 3109,
	3119, 3121, 3123, 3126, 3129, 3132, 3135, 3138,
	3144, 3152, 3160, 3162, 3172, 3200, 3228, 3256,
	0
};

static const short _spss_commands_cond_targs[] = {
	629, 0, 3, 2, 3, 629, 4, 3,
	3, 2, 629, 3, 2, 6, 0, 7,
	6, 7, 628, 6, 9, 0, 10, 0,
	11, 0, 12, 0, 13, 0, 14, 0,
	15, 0, 628, 15, 17, 618, 17, 618,
	0, 18, 18, 0, 19, 19, 0, 20,
	21, 22, 20, 585, 585, 0, 20, 21,
	22, 20, 23, 23, 0, 20, 21, 22,
	20, 23, 23, 0, 21, 0, 24, 24,
	0, 25, 25, 0, 26, 26, 0, 27,
	28, 29, 27, 0, 27, 28, 29, 27,
	30, 562, 575, 30, 562, 575, 0, 27,
	28, 29, 27, 30, 562, 575, 30, 562,
	575, 0, 28, 0, 31, 31, 0, 32,
	583, 32, 583, 0, 33, 33, 0, 33,
	34, 35, 33, 36, 0, 33, 34, 35,
	33, 36, 0, 34, 0, 36, 37, 38,
	36, 39, 580, 582, 582, 0, 36, 37,
	38, 36, 39, 580, 582, 582, 0, 37,
	0, 41, 40, 41, 40, 42, 43, 44,
	42, 45, 0, 42, 43, 44, 42, 45,
	30, 562, 575, 30, 562, 575, 0, 42,
	43, 44, 42, 45, 30, 562, 575, 30,
	562, 575, 0, 43, 0, 46, 47, 48,
	46, 561, 0, 46, 47, 48, 46, 49,
	49, 0, 46, 47, 48, 46, 49, 49,
	0, 47, 0, 50, 51, 52, 50, 49,
	49, 49, 49, 0, 50, 51, 52, 50,
	53, 0, 50, 51, 52, 50, 53, 0,
	51, 0, 54, 55, 56, 54, 557, 53,
	0, 54, 55, 56, 54, 57, 63, 63,
	0, 54, 55, 56, 54, 57, 63, 63,
	0, 55, 0, 554, 554, 58, 0, 59,
	58, 0, 60, 61, 62, 60, 0, 60,
	61, 62, 60, 63, 63, 0, 60, 61,
	62, 60, 63, 63, 0, 61, 0, 64,
	65, 66, 64, 63, 63, 63, 63, 0,
	64, 65, 66, 64, 67, 0, 64, 65,
	66, 64, 67, 0, 65, 0, 68, 69,
	70, 68, 550, 630, 45, 67, 0, 68,
	69, 70, 68, 71, 630, 45, 63, 63,
	0, 68, 69, 70, 68, 71, 630, 45,
	63, 63, 0, 69, 0, 547, 547, 72,
	0, 73, 72, 0, 74, 75, 76, 74,
	630, 45, 0, 74, 75, 76, 74, 630,
	45, 63, 63, 0, 74, 75, 76, 74,
	630, 45, 63, 63, 0, 75, 0, 78,
	100, 78, 100, 0, 79, 79, 0, 80,
	81, 82, 80, 0, 80, 81, 82, 80,
	83, 83, 0, 80, 81, 82, 80, 83,
	83, 0, 81, 0, 84, 84, 0, 85,
	85, 0, 86, 86, 0, 87, 87, 0,
	88, 89, 90, 88, 0, 88, 89, 90,
	88, 91, 91, 0, 88, 89, 90, 88,
	91, 91, 0, 89, 0, 92, 92, 0,
	93, 93, 0, 94, 94, 0, 95, 95,
	0, 96, 96, 0, 97, 97, 0, 97,
	98, 99, 97, 628, 0, 97, 98, 99,
	97, 628, 0, 98, 0, 101, 101, 0,
	102, 102, 0, 103, 103, 0, 104, 104,
	0, 97, 97, 0, 106, 143, 106, 143,
	0, 107, 107, 0, 108, 108, 0, 109,
	110, 111, 109, 0, 109, 110, 111, 109,
	112, 112, 0, 109, 110, 111, 109, 112,
	112, 0, 110, 0, 113, 113, 0, 114,
	114, 0, 115, 115, 0, 116, 116, 0,
	117, 117, 0, 118, 119, 120, 118, 0,
	118, 119, 120, 118, 121, 121, 0, 118,
	119, 120, 118, 121, 121, 0, 119, 0,
	122, 123, 124, 122, 121, 121, 121, 121,
	0, 122, 123, 124, 122, 125, 0, 122,
	123, 124, 122, 125, 0, 123, 0, 126,
	126, 0, 127, 128, 129, 127, 130, 126,
	126, 126, 126, 0, 127, 128, 129, 127,
	130, 0, 127, 128, 129, 127, 130, 0,
	128, 0, 130, 131, 132, 130, 133, 139,
	141, 142, 142, 0, 130, 131, 132, 130,
	133, 139, 141, 142, 142, 0, 131, 0,
	135, 134, 135, 134, 136, 137, 138, 136,
	628, 125, 0, 136, 137, 138, 136, 628,
	125, 0, 136, 137, 138, 136, 628, 125,
	0, 137, 0, 135, 140, 135, 140, 136,
	137, 138, 136, 628, 125, 141, 0, 136,
	137, 138, 136, 628, 125, 142, 142, 142,
	142, 0, 144, 144, 0, 145, 145, 0,
	146, 146, 0, 147, 147, 0, 148, 148,
	0, 149, 150, 151, 149, 0, 149, 150,
	151, 149, 152, 152, 0, 149, 150, 151,
	149, 152, 152, 0, 150, 0, 153, 154,
	155, 153, 152, 152, 152, 152, 0, 153,
	154, 155, 153, 156, 152, 152, 0, 153,
	154, 155, 153, 156, 152, 152, 0, 154,
	0, 157, 0, 158, 0, 159, 158, 0,
	160, 0, 161, 160, 0, 162, 163, 164,
	162, 628, 0, 162, 163, 164, 162, 628,
	148, 0, 162, 163, 164, 162, 628, 148,
	0, 163, 0, 166, 166, 0, 167, 167,
	0, 168, 169, 170, 168, 0, 168, 169,
	170, 168, 171, 538, 171, 538, 0, 168,
	169, 170, 168, 171, 538, 171, 538, 0,
	169, 0, 172, 172, 0, 173, 173, 0,
	174, 174, 0, 175, 176, 177, 175, 0,
	175, 176, 177, 175, 178, 0, 175, 176,
	177, 175, 178, 0, 176, 0, 196, 196,
	179, 179, 0, 180, 181, 182, 180, 183,
	179, 179, 179, 179, 0, 180, 181, 182,
	180, 183, 0, 180, 181, 182, 180, 183,
	0, 181, 0, 183, 184, 185, 183, 186,
	192, 194, 195, 195, 0, 183, 184, 185,
	183, 186, 192, 194, 195, 195, 0, 184,
	0, 188, 187, 188, 187, 189, 190, 191,
	189, 628, 178, 0, 189, 190, 191, 189,
	628, 178, 0, 189, 190, 191, 189, 628,
	178, 0, 190, 0, 188, 193, 188, 193,
	189, 190, 191, 189, 628, 178, 194, 0,
	189, 190, 191, 189, 628, 178, 195, 195,
	195, 195, 0, 180, 181, 182, 180, 183,
	197, 179, 197, 179, 179, 179, 0, 180,
	181, 182, 180, 183, 198, 179, 198, 179,
	179, 179, 0, 180, 181, 182, 180, 183,
	199, 179, 199, 179, 179, 179, 0, 180,
	181, 182, 180, 183, 200, 179, 200, 179,
	179, 179, 0, 180, 181, 182, 180, 183,
	201, 179, 201, 179, 179, 179, 0, 180,
	181, 182, 180, 183, 202, 179, 202, 179,
	179, 179, 0, 180, 181, 182, 180, 183,
	203, 179, 203, 179, 179, 179, 0, 180,
	181, 182, 180, 183, 204, 179, 204, 179,
	179, 179, 0, 205, 206, 207, 205, 208,
	179, 179, 179, 179, 0, 205, 206, 207,
	205, 208, 0, 205, 206, 207, 205, 208,
	0, 206, 0, 208, 209, 210, 208, 186,
	192, 194, 211, 211, 0, 208, 209, 210,
	208, 186, 192, 194, 211, 211, 0, 209,
	0, 212, 213, 214, 212, 628, 178, 211,
	211, 211, 211, 0, 212, 213, 214, 212,
	628, 178, 215, 224, 229, 215, 224, 229,
	0, 212, 213, 214, 212, 628, 178, 215,
	224, 229, 215, 224, 229, 0, 213, 0,
	533, 533, 216, 0, 217, 218, 219, 217,
	628, 178, 216, 0, 217, 218, 219, 217,
	628, 178, 220, 220, 0, 217, 218, 219,
	217, 628, 178, 220, 220, 0, 218, 0,
	221, 222, 223, 221, 220, 220, 220, 220,
	0, 221, 222, 223, 221, 215, 224, 229,
	215, 224, 229, 0, 221, 222, 223, 221,
	215, 224, 229, 215, 224, 229, 0, 222,
	0, 225, 225, 0, 226, 226, 0, 227,
	227, 0, 228, 0, 217, 218, 219, 217,
	628, 178, 228, 0, 230, 0, 217, 218,
	219, 217, 631, 178, 230, 0, 217, 218,
	219, 217, 628, 178, 231, 0, 233, 233,
	0, 234, 234, 0, 97, 97, 0, 236,
	236, 0, 237, 237, 0, 238, 238, 0,
	239, 239, 0, 240, 240, 0, 241, 241,
	0, 242, 243, 244, 242, 0, 242, 243,
	244, 242, 245, 245, 0, 242, 243, 244,
	242, 245, 245, 0, 243, 0, 246, 246,
	0, 247, 247, 0, 248, 248, 0, 249,
	249, 0, 250, 250, 0, 251, 252, 253,
	251, 0, 251, 252, 253, 251, 254, 254,
	0, 251, 252, 253, 251, 254, 254, 0,
	252, 0, 255, 256, 257, 255, 254, 254,
	254, 254, 0, 255, 256, 257, 255, 258,
	0, 255, 256, 257, 255, 258, 0, 256,
	0, 259, 266, 0, 261, 260, 261, 260,
	262, 0, 263, 264, 265, 263, 628, 0,
	263, 264, 265, 263, 628, 254, 254, 0,
	263, 264, 265, 263, 628, 254, 254, 0,
	264, 0, 261, 267, 261, 267, 269, 269,
	0, 270, 270, 0, 271, 271, 0, 272,
	272, 0, 273, 273, 0, 274, 275, 276,
	274, 0, 274, 275, 276, 274, 277, 277,
	0, 274, 275, 276, 274, 277, 277, 0,
	275, 0, 278, 279, 280, 278, 277, 277,
	277, 277, 0, 278, 279, 280, 278, 281,
	0, 278, 279, 280, 278, 281, 0, 279,
	0, 282, 283, 0, 283, 0, 284, 285,
	286, 284, 287, 289, 283, 0, 284, 285,
	286, 284, 282, 283, 0, 284, 285, 286,
	284, 282, 283, 0, 285, 0, 288, 0,
	284, 285, 286, 284, 289, 288, 0, 289,
	290, 291, 289, 292, 0, 289, 290, 291,
	289, 292, 0, 290, 0, 293, 0, 294,
	0, 295, 0, 296, 0, 297, 0, 297,
	298, 299, 297, 97, 0, 297, 298, 299,
	297, 97, 0, 298, 0, 301, 351, 301,
	351, 0, 302, 302, 0, 303, 303, 0,
	304, 305, 306, 304, 0, 304, 305, 306,
	304, 307, 345, 307, 345, 0, 304, 305,
	306, 304, 307, 345, 307, 345, 0, 305,
	0, 308, 308, 0, 309, 309, 0, 310,
	310, 0, 311, 311, 0, 312, 312, 0,
	313, 313, 0, 314, 314, 0, 315, 315,
	0, 316, 316, 0, 316, 317, 318, 316,
	319, 340, 342, 0, 316, 317, 318, 316,
	319, 340, 342, 0, 317, 0, 321, 320,
	321, 320, 322, 323, 324, 322, 628, 337,
	0, 322, 323, 324, 322, 628, 325, 0,
	322, 323, 324, 322, 628, 325, 0, 323,
	0, 325, 326, 327, 325, 328, 0, 325,
	326, 327, 325, 328, 0, 326, 0, 329,
	0, 330, 0, 331, 0, 332, 0, 333,
	0, 334, 0, 335, 0, 336, 0, 97,
	0, 337, 338, 339, 337, 628, 325, 328,
	0, 337, 338, 339, 337, 628, 325, 328,
	0, 338, 0, 321, 341, 321, 341, 342,
	343, 344, 342, 319, 340, 0, 342, 343,
	344, 342, 319, 340, 0, 343, 0, 346,
	346, 0, 347, 347, 0, 348, 348, 0,
	349, 349, 0, 350, 350, 0, 316, 316,
	0, 352, 376, 352, 376, 0, 353, 353,
	0, 354, 354, 0, 355, 355, 0, 356,
	357, 358, 356, 0, 356, 357, 358, 356,
	359, 359, 0, 356, 357, 358, 356, 359,
	359, 0, 357, 0, 360, 360, 0, 361,
	374, 375, 361, 0, 362, 363, 364, 362,
	365, 368, 370, 362, 371, 372, 372, 0,
	362, 363, 364, 362, 365, 368, 370, 628,
	362, 371, 372, 372, 0, 362, 363, 364,
	362, 365, 368, 370, 628, 362, 371, 372,
	372, 0, 363, 0, 367, 366, 367, 366,
	362, 363, 364, 362, 365, 368, 370, 628,
	362, 371, 372, 372, 0, 367, 369, 367,
	369, 371, 0, 362, 363, 364, 362, 365,
	368, 370, 628, 362, 371, 372, 372, 0,
	362, 363, 364, 362, 365, 368, 370, 628,
	372, 362, 373, 372, 372, 0, 362, 363,
	364, 362, 365, 368, 370, 628, 372, 362,
	373, 372, 372, 0, 362, 363, 364, 362,
	365, 368, 370, 362, 371, 372, 372, 0,
	374, 0, 377, 378, 379, 377, 0, 377,
	378, 379, 377, 380, 380, 0, 377, 378,
	379, 377, 380, 380, 0, 378, 0, 381,
	382, 383, 381, 384, 380, 380, 380, 380,
	0, 381, 382, 383, 381, 384, 0, 381,
	382, 383, 381, 384, 0, 382, 0, 384,
	385, 386, 384, 387, 390, 392, 393, 393,
	0, 384, 385, 386, 384, 387, 390, 392,
	393, 393, 0, 385, 0, 389, 388, 389,
	388, 97, 98, 99, 97, 628, 0, 389,
	391, 389, 391, 97, 98, 99, 97, 628,
	392, 0, 97, 98, 99, 97, 628, 393,
	393, 393, 393, 0, 395, 395, 0, 396,
	499, 396, 499, 0, 397, 397, 0, 398,
	398, 0, 399, 400, 401, 399, 0, 399,
	400, 401, 399, 402, 402, 0, 399, 400,
	401, 399, 402, 402, 0, 400, 0, 403,
	403, 0, 404, 404, 0, 405, 405, 0,
	406, 406, 0, 407, 407, 0, 408, 409,
	410, 408, 0, 408, 409, 410, 408, 411,
	414, 414, 0, 408, 409, 410, 408, 411,
	414, 414, 0, 409, 0, 411, 412, 413,
	411, 414, 414, 0, 411, 412, 413, 411,
	414, 414, 0, 412, 0, 415, 416, 417,
	415, 414, 414, 414, 414, 0, 415, 416,
	417, 415, 418, 430, 432, 448, 449, 460,
	460, 0, 415, 416, 417, 415, 418, 430,
	432, 448, 449, 460, 460, 0, 416, 0,
	420, 419, 420, 419, 421, 422, 423, 421,
	0, 421, 422, 423, 421, 424, 453, 0,
	421, 422, 423, 421, 424, 453, 0, 422,
	0, 426, 425, 426, 425, 427, 428, 429,
	427, 628, 434, 0, 427, 428, 429, 427,
	418, 430, 432, 628, 434, 449, 0, 427,
	428, 429, 427, 418, 430, 432, 628, 434,
	449, 0, 428, 0, 420, 431, 420, 431,
	433, 0, 421, 422, 423, 421, 433, 0,
	434, 435, 436, 434, 628, 437, 437, 414,
	414, 0, 434, 435, 436, 434, 628, 437,
	437, 414, 414, 0, 435, 0, 415, 416,
	417, 415, 438, 414, 438, 414, 414, 414,
	0, 415, 416, 417, 415, 439, 414, 439,
	414, 414, 414, 0, 415, 416, 417, 415,
	440, 414, 440, 414, 414, 414, 0, 415,
	416, 417, 415, 441, 414, 441, 414, 414,
	414, 0, 415, 416, 417, 415, 442, 414,
	442, 414, 414, 414, 0, 415, 416, 417,
	415, 443, 414, 443, 414, 414, 414, 0,
	415, 416, 417, 415, 444, 414, 444, 414,
	414, 414, 0, 445, 446, 447, 445, 414,
	414, 414, 414, 0, 445, 446, 447, 445,
	418, 430, 432, 448, 461, 461, 449, 460,
	460, 0, 445, 446, 447, 445, 418, 430,
	432, 448, 461, 461, 449, 460, 460, 0,
	446, 0, 421, 422, 423, 421, 0, 450,
	451, 452, 450, 449, 0, 450, 451, 452,
	450, 424, 453, 455, 0, 450, 451, 452,
	450, 424, 453, 455, 0, 451, 0, 426,
	454, 426, 454, 456, 457, 458, 456, 0,
	456, 457, 458, 456, 459, 0, 456, 457,
	458, 456, 459, 0, 457, 0, 421, 422,
	423, 421, 459, 0, 415, 416, 417, 415,
	460, 460, 460, 460, 0, 415, 416, 417,
	415, 462, 460, 462, 460, 460, 460, 0,
	415, 416, 417, 415, 463, 460, 463, 460,
	460, 460, 0, 415, 416, 417, 415, 464,
	460, 464, 460, 460, 460, 0, 415, 416,
	417, 415, 465, 460, 465, 460, 460, 460,
	0, 466, 467, 468, 466, 460, 460, 460,
	460, 0, 466, 467, 468, 466, 418, 430,
	432, 448, 449, 469, 469, 0, 466, 467,
	468, 466, 418, 430, 432, 448, 449, 469,
	469, 0, 467, 0, 470, 471, 472, 470,
	469, 469, 469, 469, 0, 470, 471, 472,
	470, 418, 430, 473, 432, 448, 449, 498,
	498, 0, 470, 471, 472, 470, 418, 430,
	473, 432, 448, 449, 498, 498, 0, 471,
	0, 474, 492, 494, 474, 492, 494, 0,
	475, 475, 0, 476, 476, 0, 477, 477,
	0, 478, 478, 0, 479, 479, 0, 480,
	480, 0, 481, 0, 481, 482, 483, 481,
	628, 484, 0, 481, 482, 483, 481, 628,
	484, 0, 482, 0, 484, 485, 486, 484,
	487, 487, 0, 484, 485, 486, 484, 487,
	487, 0, 485, 0, 488, 489, 490, 488,
	487, 487, 487, 487, 0, 488, 489, 490,
	488, 473, 491, 491, 0, 488, 489, 490,
	488, 473, 491, 491, 0, 489, 0, 488,
	489, 490, 488, 491, 491, 491, 491, 0,
	493, 493, 0, 476, 476, 0, 495, 495,
	0, 496, 496, 0, 497, 497, 0, 480,
	480, 0, 470, 471, 472, 470, 498, 498,
	498, 498, 0, 500, 500, 0, 501, 501,
	0, 502, 502, 0, 503, 503, 0, 504,
	504, 0, 505, 506, 507, 505, 0, 505,
	506, 507, 505, 508, 508, 0, 505, 506,
	507, 505, 508, 508, 0, 506, 0, 509,
	509, 0, 510, 510, 0, 511, 511, 0,
	512, 512, 0, 513, 514, 515, 513, 532,
	532, 0, 513, 514, 515, 513, 516, 516,
	0, 513, 514, 515, 513, 516, 516, 0,
	514, 0, 517, 518, 519, 517, 516, 516,
	516, 516, 0, 517, 518, 519, 517, 520,
	530, 0, 517, 518, 519, 517, 520, 530,
	0, 518, 0, 522, 521, 522, 521, 523,
	524, 525, 523, 628, 526, 0, 523, 524,
	525, 523, 628, 526, 516, 516, 0, 523,
	524, 525, 523, 628, 526, 516, 516, 0,
	524, 0, 527, 528, 529, 527, 628, 0,
	527, 528, 529, 527, 628, 516, 516, 0,
	527, 528, 529, 527, 628, 516, 516, 0,
	528, 0, 522, 531, 522, 531, 513, 514,
	515, 513, 0, 534, 534, 0, 535, 535,
	0, 536, 536, 0, 537, 0, 217, 218,
	219, 217, 628, 178, 537, 0, 539, 539,
	0, 540, 540, 0, 541, 541, 0, 541,
	542, 543, 541, 387, 390, 544, 0, 541,
	542, 543, 541, 387, 390, 544, 0, 542,
	0, 544, 545, 546, 544, 387, 390, 0,
	544, 545, 546, 544, 387, 390, 0, 545,
	0, 548, 549, 0, 74, 75, 76, 74,
	630, 45, 0, 548, 549, 0, 550, 551,
	552, 550, 553, 0, 550, 551, 552, 550,
	553, 0, 551, 0, 68, 69, 70, 68,
	630, 45, 553, 0, 555, 556, 0, 60,
	61, 62, 60, 0, 555, 556, 0, 557,
	558, 559, 557, 560, 0, 557, 558, 559,
	557, 560, 0, 558, 0, 54, 55, 56,
	54, 560, 0, 46, 47, 48, 46, 561,
	0, 563, 563, 0, 564, 564, 0, 565,
	565, 0, 566, 566, 0, 567, 567, 0,
	568, 569, 570, 568, 571, 568, 568, 0,
	568, 569, 570, 568, 571, 0, 568, 569,
	570, 568, 571, 0, 569, 0, 571, 572,
	573, 571, 574, 0, 571, 572, 573, 571,
	574, 0, 572, 0, 42, 43, 44, 42,
	45, 574, 0, 576, 576, 0, 577, 577,
	0, 578, 578, 0, 579, 579, 0, 42,
	43, 44, 42, 45, 0, 41, 581, 41,
	581, 42, 43, 44, 42, 45, 582, 582,
	582, 582, 0, 584, 584, 0, 579, 579,
	0, 586, 586, 0, 587, 587, 0, 588,
	589, 590, 588, 0, 588, 589, 590, 588,
	591, 591, 0, 588, 589, 590, 588, 591,
	591, 0, 589, 0, 592, 592, 0, 593,
	593, 0, 594, 594, 0, 595, 596, 597,
	595, 0, 595, 596, 597, 595, 598, 616,
	615, 615, 0, 595, 596, 597, 595, 598,
	616, 615, 615, 0, 596, 0, 600, 599,
	600, 599, 601, 602, 603, 601, 628, 0,
	601, 602, 603, 601, 604, 604, 0, 601,
	602, 603, 601, 604, 604, 0, 602, 0,
	605, 605, 0, 606, 606, 0, 607, 607,
	0, 608, 608, 0, 609, 609, 0, 609,
	610, 611, 609, 612, 0, 609, 610, 611,
	609, 612, 0, 610, 0, 612, 613, 614,
	612, 615, 615, 0, 612, 613, 614, 612,
	615, 615, 0, 613, 0, 601, 602, 603,
	601, 628, 615, 615, 615, 615, 0, 600,
	617, 600, 617, 619, 619, 0, 620, 620,
	0, 621, 621, 0, 622, 622, 0, 623,
	623, 0, 624, 625, 626, 624, 628, 0,
	624, 625, 626, 624, 628, 627, 627, 0,
	624, 625, 626, 624, 628, 627, 627, 0,
	625, 0, 624, 625, 626, 624, 628, 627,
	627, 627, 627, 0, 628, 629, 1, 628,
	2, 5, 8, 16, 77, 105, 165, 83,
	232, 235, 268, 300, 394, 16, 77, 105,
	165, 83, 232, 235, 268, 300, 394, 0,
	628, 629, 1, 628, 2, 5, 8, 16,
	77, 105, 165, 83, 232, 235, 268, 300,
	394, 16, 77, 105, 165, 83, 232, 235,
	268, 300, 394, 0, 628, 629, 1, 628,
	2, 5, 8, 16, 77, 105, 165, 83,
	232, 235, 268, 300, 394, 16, 77, 105,
	165, 83, 232, 235, 268, 300, 394, 0,
	628, 629, 1, 628, 2, 5, 8, 16,
	77, 105, 165, 83, 232, 235, 268, 300,
	394, 16, 77, 105, 165, 83, 232, 235,
	268, 300, 394, 231, 0, 0, 1, 2,
	3, 4, 5, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 16, 17, 18,
	19, 20, 21, 22, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34,
	35, 36, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 72, 73, 74,
	75, 76, 77, 78, 79, 80, 81, 82,
	83, 84, 85, 86, 87, 88, 89, 90,
	91, 92, 93, 94, 95, 96, 97, 98,
	99, 100, 101, 102, 103, 104, 105, 106,
	107, 108, 109, 110, 111, 112, 113, 114,
	115, 116, 117, 118, 119, 120, 121, 122,
	123, 124, 125, 126, 127, 128, 129, 130,
	131, 132, 133, 134, 135, 136, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146,
	147, 148, 149, 150, 151, 152, 153, 154,
	155, 156, 157, 158, 159, 160, 161, 162,
	163, 164, 165, 166, 167, 168, 169, 170,
	171, 172, 173, 174, 175, 176, 177, 178,
	179, 180, 181, 182, 183, 184, 185, 186,
	187, 188, 189, 190, 191, 192, 193, 194,
	195, 196, 197, 198, 199, 200, 201, 202,
	203, 204, 205, 206, 207, 208, 209, 210,
	211, 212, 213, 214, 215, 216, 217, 218,
	219, 220, 221, 222, 223, 224, 225, 226,
	227, 228, 229, 230, 231, 232, 233, 234,
	235, 236, 237, 238, 239, 240, 241, 242,
	243, 244, 245, 246, 247, 248, 249, 250,
	251, 252, 253, 254, 255, 256, 257, 258,
	259, 260, 261, 262, 263, 264, 265, 266,
	267, 268, 269, 270, 271, 272, 273, 274,
	275, 276, 277, 278, 279, 280, 281, 282,
	283, 284, 285, 286, 287, 288, 289, 290,
	291, 292, 293, 294, 295, 296, 297, 298,
	299, 300, 301, 302, 303, 304, 305, 306,
	307, 308, 309, 310, 311, 312, 313, 314,
	315, 316, 317, 318, 319, 320, 321, 322,
	323, 324, 325, 326, 327, 328, 329, 330,
	331, 332, 333, 334, 335, 336, 337, 338,
	339, 340, 341, 342, 343, 344, 345, 346,
	347, 348, 349, 350, 351, 352, 353, 354,
	355, 356, 357, 358, 359, 360, 361, 362,
	363, 364, 365, 366, 367, 368, 369, 370,
	371, 372, 373, 374, 375, 376, 377, 378,
	379, 380, 381, 382, 383, 384, 385, 386,
	387, 388, 389, 390, 391, 392, 393, 394,
	395, 396, 397, 398, 399, 400, 401, 402,
	403, 404, 405, 406, 407, 408, 409, 410,
	411, 412, 413, 414, 415, 416, 417, 418,
	419, 420, 421, 422, 423, 424, 425, 426,
	427, 428, 429, 430, 431, 432, 433, 434,
	435, 436, 437, 438, 439, 440, 441, 442,
	443, 444, 445, 446, 447, 448, 449, 450,
	451, 452, 453, 454, 455, 456, 457, 458,
	459, 460, 461, 462, 463, 464, 465, 466,
	467, 468, 469, 470, 471, 472, 473, 474,
	475, 476, 477, 478, 479, 480, 481, 482,
	483, 484, 485, 486, 487, 488, 489, 490,
	491, 492, 493, 494, 495, 496, 497, 498,
	499, 500, 501, 502, 503, 504, 505, 506,
	507, 508, 509, 510, 511, 512, 513, 514,
	515, 516, 517, 518, 519, 520, 521, 522,
	523, 524, 525, 526, 527, 528, 529, 530,
	531, 532, 533, 534, 535, 536, 537, 538,
	539, 540, 541, 542, 543, 544, 545, 546,
	547, 548, 549, 550, 551, 552, 553, 554,
	555, 556, 557, 558, 559, 560, 561, 562,
	563, 564, 565, 566, 567, 568, 569, 570,
	571, 572, 573, 574, 575, 576, 577, 578,
	579, 580, 581, 582, 583, 584, 585, 586,
	587, 588, 589, 590, 591, 592, 593, 594,
	595, 596, 597, 598, 599, 600, 601, 602,
	603, 604, 605, 606, 607, 608, 609, 610,
	611, 612, 613, 614, 615, 616, 617, 618,
	619, 620, 621, 622, 623, 624, 625, 626,
	627, 628, 629, 630, 631, 0
};

static const short _spss_commands_cond_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 23, 23, 0, 21, 21,
	21, 21, 21, 21, 81, 81, 0, 0,
	0, 75, 17, 19, 0, 5, 5, 5,
	5, 5, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 39, 0, 0, 0, 0, 0, 23,
	23, 0, 21, 21, 21, 21, 81, 81,
	0, 0, 0, 84, 84, 84, 84, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	39, 0, 21, 21, 21, 21, 120, 0,
	0, 0, 45, 45, 45, 45, 3, 1,
	0, 0, 0, 0, 0, 0, 69, 69,
	0, 21, 21, 21, 21, 21, 124, 124,
	0, 0, 0, 0, 0, 39, 0, 0,
	1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 69, 69, 0, 21, 21,
	21, 21, 124, 124, 0, 0, 0, 84,
	84, 84, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 0, 21, 21,
	21, 21, 120, 0, 0, 0, 48, 48,
	48, 48, 3, 48, 48, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 69, 69,
	0, 21, 21, 21, 21, 21, 21, 21,
	124, 124, 0, 0, 0, 0, 0, 39,
	0, 0, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 69, 69, 0, 21, 21, 21, 21,
	21, 21, 124, 124, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	25, 25, 25, 25, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 0, 0, 0, 23,
	23, 0, 87, 87, 87, 87, 87, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	39, 23, 23, 0, 21, 21, 21, 21,
	21, 21, 120, 81, 81, 0, 0, 0,
	75, 17, 19, 0, 5, 5, 5, 5,
	5, 5, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 21,
	0, 0, 0, 72, 13, 15, 0, 0,
	0, 0, 0, 0, 0, 1, 0, 25,
	25, 25, 25, 25, 25, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 0, 21, 21, 21,
	21, 81, 81, 0, 0, 0, 25, 25,
	25, 25, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 21,
	21, 21, 21, 21, 81, 81, 0, 0,
	0, 0, 0, 39, 0, 0, 1, 0,
	39, 0, 0, 1, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 21,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 21, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 0, 0, 0, 23, 23,
	23, 23, 0, 87, 87, 87, 87, 87,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 39, 23, 23, 0, 21, 21, 21,
	21, 21, 21, 120, 81, 81, 0, 0,
	0, 75, 17, 19, 0, 60, 60, 60,
	60, 60, 60, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 72, 13, 15, 0,
	9, 9, 9, 9, 9, 9, 1, 0,
	90, 90, 90, 90, 90, 90, 0, 0,
	0, 0, 0, 87, 87, 87, 87, 87,
	0, 0, 0, 0, 0, 0, 0, 87,
	87, 87, 87, 87, 0, 0, 0, 0,
	0, 0, 0, 87, 87, 87, 87, 87,
	0, 0, 0, 0, 0, 0, 0, 87,
	87, 87, 87, 87, 0, 0, 0, 0,
	0, 0, 0, 87, 87, 87, 87, 87,
	0, 0, 0, 0, 0, 0, 0, 87,
	87, 87, 87, 87, 0, 0, 0, 0,
	0, 0, 0, 87, 87, 87, 87, 87,
	0, 0, 0, 0, 0, 0, 0, 87,
	87, 87, 87, 87, 0, 0, 0, 0,
	0, 0, 0, 87, 87, 87, 87, 87,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 39, 23, 23, 0, 21, 21, 21,
	21, 21, 21, 120, 81, 81, 0, 0,
	0, 140, 140, 140, 140, 90, 90, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 0, 0, 0,
	0, 0, 39, 0, 96, 96, 96, 96,
	96, 96, 1, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 0, 21, 21, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	84, 84, 84, 84, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 39, 0, 102, 102, 102, 102,
	102, 102, 1, 0, 39, 0, 99, 99,
	99, 99, 99, 99, 1, 0, 7, 7,
	7, 7, 7, 7, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	0, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 84, 84, 84, 84, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 75, 17, 19, 0,
	5, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 23, 23, 0,
	21, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 72, 13, 15, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	0, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 25, 25, 25, 25, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 39, 0, 39, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 0, 0,
	0, 0, 0, 39, 0, 21, 21, 21,
	21, 21, 120, 0, 0, 0, 39, 0,
	0, 0, 0, 0, 0, 1, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 21, 0, 0, 0, 75, 17,
	19, 0, 5, 5, 5, 5, 5, 5,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 21,
	0, 0, 0, 72, 13, 15, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 23, 23, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 39, 23, 23, 0, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 120, 81,
	81, 0, 0, 0, 75, 17, 19, 0,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 108, 66, 66, 0, 72, 13, 15,
	0, 39, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 42, 23, 23, 0,
	25, 25, 25, 25, 25, 25, 25, 25,
	0, 25, 128, 93, 93, 0, 25, 25,
	25, 25, 25, 25, 25, 25, 0, 25,
	132, 93, 93, 0, 21, 21, 21, 21,
	21, 21, 21, 21, 120, 81, 81, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 23, 23, 0, 21, 21,
	21, 21, 81, 81, 0, 0, 0, 25,
	25, 25, 25, 25, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 39, 23, 23,
	0, 21, 21, 21, 21, 21, 21, 120,
	81, 81, 0, 0, 0, 75, 17, 19,
	0, 5, 5, 5, 5, 5, 0, 72,
	13, 15, 0, 0, 0, 0, 0, 0,
	1, 0, 25, 25, 25, 25, 25, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	23, 23, 0, 21, 21, 21, 21, 21,
	81, 81, 0, 0, 0, 0, 0, 0,
	0, 23, 23, 0, 21, 21, 21, 21,
	81, 81, 0, 0, 0, 153, 153, 153,
	153, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 39, 23,
	23, 0, 21, 21, 21, 21, 21, 21,
	21, 21, 120, 81, 81, 0, 0, 0,
	75, 17, 19, 0, 116, 116, 116, 116,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 75, 17, 19, 0, 63, 63, 63,
	63, 112, 112, 0, 0, 0, 0, 0,
	0, 0, 0, 11, 11, 39, 0, 21,
	21, 21, 21, 21, 21, 21, 78, 78,
	120, 0, 0, 0, 72, 13, 15, 0,
	39, 0, 33, 33, 33, 33, 1, 0,
	0, 0, 0, 0, 0, 23, 23, 23,
	23, 0, 21, 21, 21, 21, 21, 81,
	81, 81, 81, 0, 0, 0, 153, 153,
	153, 153, 0, 0, 0, 0, 0, 0,
	0, 153, 153, 153, 153, 0, 0, 0,
	0, 0, 0, 0, 153, 153, 153, 153,
	0, 0, 0, 0, 0, 0, 0, 153,
	153, 153, 153, 0, 0, 0, 0, 0,
	0, 0, 153, 153, 153, 153, 0, 0,
	0, 0, 0, 0, 0, 153, 153, 153,
	153, 0, 0, 0, 0, 0, 0, 0,
	153, 153, 153, 153, 0, 0, 0, 0,
	0, 0, 0, 153, 153, 153, 153, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 39, 23,
	23, 0, 21, 21, 21, 21, 21, 21,
	21, 21, 81, 81, 120, 81, 81, 0,
	0, 0, 31, 31, 31, 31, 0, 35,
	35, 35, 35, 1, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 72,
	13, 15, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 144, 0, 21, 21,
	21, 21, 148, 0, 0, 0, 37, 37,
	37, 37, 1, 0, 136, 136, 136, 136,
	0, 0, 0, 0, 0, 136, 136, 136,
	136, 0, 0, 0, 0, 0, 0, 0,
	136, 136, 136, 136, 0, 0, 0, 0,
	0, 0, 0, 136, 136, 136, 136, 0,
	0, 0, 0, 0, 0, 0, 136, 136,
	136, 136, 0, 0, 0, 0, 0, 0,
	0, 136, 136, 136, 136, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 39, 23, 23, 0, 21, 21,
	21, 21, 21, 21, 21, 21, 120, 81,
	81, 0, 0, 0, 158, 158, 158, 158,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 39, 23,
	23, 0, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 120, 81, 81, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	23, 23, 0, 21, 21, 21, 21, 81,
	81, 0, 0, 0, 153, 153, 153, 153,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 0, 21, 21, 21,
	21, 21, 81, 81, 0, 0, 0, 136,
	136, 136, 136, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 136, 136, 136, 136, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	0, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 84, 84, 84, 84, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 21,
	0, 0, 0, 75, 17, 19, 0, 57,
	57, 57, 57, 57, 57, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 21,
	21, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 23, 23, 0,
	21, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 72, 13, 15, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 0, 105, 105,
	105, 105, 105, 105, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 39, 0, 27, 27, 27, 27,
	27, 27, 0, 0, 1, 0, 0, 0,
	0, 0, 39, 0, 21, 21, 21, 21,
	120, 0, 0, 0, 54, 54, 54, 54,
	54, 54, 1, 0, 0, 39, 0, 27,
	27, 27, 27, 0, 0, 1, 0, 0,
	0, 0, 0, 39, 0, 21, 21, 21,
	21, 120, 0, 0, 0, 51, 51, 51,
	51, 1, 0, 29, 29, 29, 29, 1,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 0, 0, 0, 0, 0,
	0, 0, 39, 0, 21, 21, 21, 21,
	120, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 72, 13, 15,
	0, 25, 25, 25, 25, 25, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	23, 23, 0, 21, 21, 21, 21, 21,
	21, 81, 81, 0, 0, 0, 75, 17,
	19, 0, 5, 5, 5, 5, 5, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 23, 23, 0, 21, 21, 21, 21,
	81, 81, 0, 0, 0, 25, 25, 25,
	25, 25, 0, 0, 0, 0, 0, 72,
	13, 15, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 23, 23, 0,
	21, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 25, 25, 25, 25, 25, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 0, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 39, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 7, 0, 0
};

static const short _spss_commands_eof_trans[] = {
	3286, 3287, 3288, 3289, 3290, 3291, 3292, 3293,
	3294, 3295, 3296, 3297, 3298, 3299, 3300, 3301,
	3302, 3303, 3304, 3305, 3306, 3307, 3308, 3309,
	3310, 3311, 3312, 3313, 3314, 3315, 3316, 3317,
	3318, 3319, 3320, 3321, 3322, 3323, 3324, 3325,
	3326, 3327, 3328, 3329, 3330, 3331, 3332, 3333,
	3334, 3335, 3336, 3337, 3338, 3339, 3340, 3341,
	3342, 3343, 3344, 3345, 3346, 3347, 3348, 3349,
	3350, 3351, 3352, 3353, 3354, 3355, 3356, 3357,
	3358, 3359, 3360, 3361, 3362, 3363, 3364, 3365,
	3366, 3367, 3368, 3369, 3370, 3371, 3372, 3373,
	3374, 3375, 3376, 3377, 3378, 3379, 3380, 3381,
	3382, 3383, 3384, 3385, 3386, 3387, 3388, 3389,
	3390, 3391, 3392, 3393, 3394, 3395, 3396, 3397,
	3398, 3399, 3400, 3401, 3402, 3403, 3404, 3405,
	3406, 3407, 3408, 3409, 3410, 3411, 3412, 3413,
	3414, 3415, 3416, 3417, 3418, 3419, 3420, 3421,
	3422, 3423, 3424, 3425, 3426, 3427, 3428, 3429,
	3430, 3431, 3432, 3433, 3434, 3435, 3436, 3437,
	3438, 3439, 3440, 3441, 3442, 3443, 3444, 3445,
	3446, 3447, 3448, 3449, 3450, 3451, 3452, 3453,
	3454, 3455, 3456, 3457, 3458, 3459, 3460, 3461,
	3462, 3463, 3464, 3465, 3466, 3467, 3468, 3469,
	3470, 3471, 3472, 3473, 3474, 3475, 3476, 3477,
	3478, 3479, 3480, 3481, 3482, 3483, 3484, 3485,
	3486, 3487, 3488, 3489, 3490, 3491, 3492, 3493,
	3494, 3495, 3496, 3497, 3498, 3499, 3500, 3501,
	3502, 3503, 3504, 3505, 3506, 3507, 3508, 3509,
	3510, 3511, 3512, 3513, 3514, 3515, 3516, 3517,
	3518, 3519, 3520, 3521, 3522, 3523, 3524, 3525,
	3526, 3527, 3528, 3529, 3530, 3531, 3532, 3533,
	3534, 3535, 3536, 3537, 3538, 3539, 3540, 3541,
	3542, 3543, 3544, 3545, 3546, 3547, 3548, 3549,
	3550, 3551, 3552, 3553, 3554, 3555, 3556, 3557,
	3558, 3559, 3560, 3561, 3562, 3563, 3564, 3565,
	3566, 3567, 3568, 3569, 3570, 3571, 3572, 3573,
	3574, 3575, 3576, 3577, 3578, 3579, 3580, 3581,
	3582, 3583, 3584, 3585, 3586, 3587, 3588, 3589,
	3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597,
	3598, 3599, 3600, 3601, 3602, 3603, 3604, 3605,
	3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613,
	3614, 3615, 3616, 3617, 3618, 3619, 3620, 3621,
	3622, 3623, 3624, 3625, 3626, 3627, 3628, 3629,
	3630, 3631, 3632, 3633, 3634, 3635, 3636, 3637,
	3638, 3639, 3640, 3641, 3642, 3643, 3644, 3645,
	3646, 3647, 3648, 3649, 3650, 3651, 3652, 3653,
	3654, 3655, 3656, 3657, 3658, 3659, 3660, 3661,
	3662, 3663, 3664, 3665, 3666, 3667, 3668, 3669,
	3670, 3671, 3672, 3673, 3674, 3675, 3676, 3677,
	3678, 3679, 3680, 3681, 3682, 3683, 3684, 3685,
	3686, 3687, 3688, 3689, 3690, 3691, 3692, 3693,
	3694, 3695, 3696, 3697, 3698, 3699, 3700, 3701,
	3702, 3703, 3704, 3705, 3706, 3707, 3708, 3709,
	3710, 3711, 3712, 3713, 3714, 3715, 3716, 3717,
	3718, 3719, 3720, 3721, 3722, 3723, 3724, 3725,
	3726, 3727, 3728, 3729, 3730, 3731, 3732, 3733,
	3734, 3735, 3736, 3737, 3738, 3739, 3740, 3741,
	3742, 3743, 3744, 3745, 3746, 3747, 3748, 3749,
	3750, 3751, 3752, 3753, 3754, 3755, 3756, 3757,
	3758, 3759, 3760, 3761, 3762, 3763, 3764, 3765,
	3766, 3767, 3768, 3769, 3770, 3771, 3772, 3773,
	3774, 3775, 3776, 3777, 3778, 3779, 3780, 3781,
	3782, 3783, 3784, 3785, 3786, 3787, 3788, 3789,
	3790, 3791, 3792, 3793, 3794, 3795, 3796, 3797,
	3798, 3799, 3800, 3801, 3802, 3803, 3804, 3805,
	3806, 3807, 3808, 3809, 3810, 3811, 3812, 3813,
	3814, 3815, 3816, 3817, 3818, 3819, 3820, 3821,
	3822, 3823, 3824, 3825, 3826, 3827, 3828, 3829,
	3830, 3831, 3832, 3833, 3834, 3835, 3836, 3837,
	3838, 3839, 3840, 3841, 3842, 3843, 3844, 3845,
	3846, 3847, 3848, 3849, 3850, 3851, 3852, 3853,
	3854, 3855, 3856, 3857, 3858, 3859, 3860, 3861,
	3862, 3863, 3864, 3865, 3866, 3867, 3868, 3869,
	3870, 3871, 3872, 3873, 3874, 3875, 3876, 3877,
	3878, 3879, 3880, 3881, 3882, 3883, 3884, 3885,
	3886, 3887, 3888, 3889, 3890, 3891, 3892, 3893,
	3894, 3895, 3896, 3897, 3898, 3899, 3900, 3901,
	3902, 3903, 3904, 3905, 3906, 3907, 3908, 3909,
	3910, 3911, 3912, 3913, 3914, 3915, 3916, 3917,
	0
};

static const int spss_commands_start = 628;

static const int spss_commands_en_main = 628;


#line 14 "src/txt/readstat_spss_commands_read.rl"


readstat_schema_t *readstat_parse_spss_commands(readstat_parser_t *parser,
const char *filepath, void *user_ctx, readstat_error_t *outError) {
	if (parser->io->open(filepath, parser->io->io_ctx) == -1) {
		if (outError)
			*outError = READSTAT_ERROR_OPEN;
		return NULL;
	}
	readstat_schema_t *schema = NULL;
	unsigned char *bytes = NULL;
	readstat_error_t error = READSTAT_OK;
	ssize_t len = parser->io->seek(0, READSTAT_SEEK_END, parser->io->io_ctx);
	if (len == -1) {
		error = READSTAT_ERROR_SEEK;
		goto cleanup;
	}
	parser->io->seek(0, READSTAT_SEEK_SET, parser->io->io_ctx);
	
	bytes = malloc(len);
	
	parser->io->read(bytes, len, parser->io->io_ctx);
	
	unsigned char *p = bytes;
	unsigned char *pe = bytes + len;
	
	unsigned char *eof = pe;
	
	unsigned char *str_start = NULL;
	
	size_t str_len = 0;
	
	int cs;
	
	int i;
	int line_no = 0;
	uint64_t first_integer = 0, integer = 0;
	double double_value = NAN;
	unsigned char *line_start = p;
	
	char varname[32];
	char argname[32];
	char string_value[32];
	char buf[1024];
	
	char var_list[1024][32];
	
	long var_col = 0;
	long var_row = 0;
	long var_len = 0;
	long var_count = 0;
	readstat_type_t var_type = READSTAT_TYPE_DOUBLE;
	label_type_t label_type = LABEL_TYPE_DOUBLE;
	
	int labelset_count = 0;
	
	if ((schema = calloc(1, sizeof(readstat_schema_t))) == NULL) {
		error = READSTAT_ERROR_MALLOC;
		goto cleanup;
	}
	
	schema->rows_per_observation = 1;
	
	
#line 1893 "src/txt/readstat_spss_commands_read.c"
	{
		cs = (int)spss_commands_start;
	}
	
#line 1898 "src/txt/readstat_spss_commands_read.c"
	{
		int _klen;
		unsigned int _trans = 0;
		const char * _keys;
		const signed char * _acts;
		unsigned int _nacts;
		_resume: {}
		if ( p == pe && p != eof )
			goto _out;
		if ( p == eof ) {
			if ( _spss_commands_eof_trans[cs] > 0 ) {
				_trans = (unsigned int)_spss_commands_eof_trans[cs] - 1;
			}
		}
		else {
			_keys = ( _spss_commands_trans_keys + (_spss_commands_key_offsets[cs]));
			_trans = (unsigned int)_spss_commands_index_offsets[cs];
			
			_klen = (int)_spss_commands_single_lengths[cs];
			if ( _klen > 0 ) {
				const char *_lower = _keys;
				const char *_upper = _keys + _klen - 1;
				const char *_mid;
				while ( 1 ) {
					if ( _upper < _lower ) {
						_keys += _klen;
						_trans += (unsigned int)_klen;
						break;
					}
					
					_mid = _lower + ((_upper-_lower) >> 1);
					if ( ( (*( p))) < (*( _mid)) )
						_upper = _mid - 1;
					else if ( ( (*( p))) > (*( _mid)) )
						_lower = _mid + 1;
					else {
						_trans += (unsigned int)(_mid - _keys);
						goto _match;
					}
				}
			}
			
			_klen = (int)_spss_commands_range_lengths[cs];
			if ( _klen > 0 ) {
				const char *_lower = _keys;
				const char *_upper = _keys + (_klen<<1) - 2;
				const char *_mid;
				while ( 1 ) {
					if ( _upper < _lower ) {
						_trans += (unsigned int)_klen;
						break;
					}
					
					_mid = _lower + (((_upper-_lower) >> 1) & ~1);
					if ( ( (*( p))) < (*( _mid)) )
						_upper = _mid - 2;
					else if ( ( (*( p))) > (*( _mid + 1)) )
						_lower = _mid + 2;
					else {
						_trans += (unsigned int)((_mid - _keys)>>1);
						break;
					}
				}
			}
			
			_match: {}
		}
		cs = (int)_spss_commands_cond_targs[_trans];
		
		if ( _spss_commands_cond_actions[_trans] != 0 ) {
			
			_acts = ( _spss_commands_actions + (_spss_commands_cond_actions[_trans]));
			_nacts = (unsigned int)(*( _acts));
			_acts += 1;
			while ( _nacts > 0 ) {
				switch ( (*( _acts)) )
				{
					case 0:  {
						{
#line 78 "src/txt/readstat_spss_commands_read.rl"
							
							integer = 0;
						}
						
#line 1983 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 1:  {
						{
#line 82 "src/txt/readstat_spss_commands_read.rl"
							
							integer = 10 * integer + ((( (*( p)))) - '0');
						}
						
#line 1994 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 2:  {
						{
#line 86 "src/txt/readstat_spss_commands_read.rl"
							
							var_col = integer - 1;
							var_len = 1;
						}
						
#line 2006 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 3:  {
						{
#line 91 "src/txt/readstat_spss_commands_read.rl"
							
							var_len = integer - var_col;
						}
						
#line 2017 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 4:  {
						{
#line 95 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy_quoted(buf, sizeof(buf), (char *)str_start, str_len);
						}
						
#line 2028 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 5:  {
						{
#line 99 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy_quoted(string_value, sizeof(string_value), (char *)str_start, str_len);
						}
						
#line 2039 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 6:  {
						{
#line 107 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy(varname, sizeof(varname), (char *)str_start, str_len);
						}
						
#line 2050 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 7:  {
						{
#line 111 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy(argname, sizeof(argname), (char *)str_start, str_len);
						}
						
#line 2061 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 8:  {
						{
#line 115 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
							entry->variable.type = var_type;
							entry->row = var_row;
							entry->col = var_col;
							entry->len = var_len;
						}
						
#line 2076 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 9:  {
						{
#line 123 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
							readstat_copy(entry->variable.label, sizeof(entry->variable.label), buf, sizeof(buf));
						}
						
#line 2088 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 10:  {
						{
#line 128 "src/txt/readstat_spss_commands_read.rl"
							
							var_count = 0;
						}
						
#line 2099 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 11:  {
						{
#line 132 "src/txt/readstat_spss_commands_read.rl"
							
							if (var_count < sizeof(var_list)/sizeof(var_list[0])) {
								memcpy(var_list[var_count++], varname, sizeof(varname));
							}
						}
						
#line 2112 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 12:  {
						{
#line 138 "src/txt/readstat_spss_commands_read.rl"
							
							if (strcasecmp(argname, "FIRSTCASE") == 0) {
								schema->first_line = integer;
							}
							if (strcasecmp(argname, "DELIMITERS") == 0) {
								schema->field_delimiter = buf[0];
							}
						}
						
#line 2128 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 13:  {
						{
#line 147 "src/txt/readstat_spss_commands_read.rl"
							
							char labelset_name[256];
							snprintf(labelset_name, sizeof(labelset_name), "labels%d", labelset_count++);
							for (i=0; i<var_count; i++) {
								readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
								readstat_copy(entry->labelset, sizeof(entry->labelset), labelset_name, sizeof(labelset_name));
							}
						}
						
#line 2144 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 14:  {
						{
#line 156 "src/txt/readstat_spss_commands_read.rl"
							
							char labelset_name[256];
							snprintf(labelset_name, sizeof(labelset_name), "labels%d", labelset_count);
							error = submit_value_label(parser, labelset_name, label_type,
							first_integer, integer, double_value, string_value, buf, user_ctx);
							if (error != READSTAT_OK)
							goto cleanup;
						}
						
#line 2160 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 15:  {
						{
#line 165 "src/txt/readstat_spss_commands_read.rl"
							str_start = p; }
						
#line 2169 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 16:  {
						{
#line 165 "src/txt/readstat_spss_commands_read.rl"
							str_len = p - str_start; }
						
#line 2178 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 17:  {
						{
#line 167 "src/txt/readstat_spss_commands_read.rl"
							str_start = p; }
						
#line 2187 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 18:  {
						{
#line 167 "src/txt/readstat_spss_commands_read.rl"
							str_len = p - str_start; }
						
#line 2196 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 19:  {
						{
#line 171 "src/txt/readstat_spss_commands_read.rl"
							line_no++; line_start = p; }
						
#line 2205 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 20:  {
						{
#line 173 "src/txt/readstat_spss_commands_read.rl"
							str_start = p; }
						
#line 2214 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 21:  {
						{
#line 173 "src/txt/readstat_spss_commands_read.rl"
							str_len = p - str_start; }
						
#line 2223 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 22:  {
						{
#line 191 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_STRING; }
						
#line 2232 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 23:  {
						{
#line 194 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_STRING; }
						
#line 2241 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 24:  {
						{
#line 195 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2250 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 25:  {
						{
#line 196 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2259 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 26:  {
						{
#line 197 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_STRING; }
						
#line 2268 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 27:  {
						{
#line 218 "src/txt/readstat_spss_commands_read.rl"
							var_row = integer - 1; }
						
#line 2277 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 28:  {
						{
#line 219 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2286 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 29:  {
						{
#line 220 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2295 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 30:  {
						{
#line 253 "src/txt/readstat_spss_commands_read.rl"
							label_type = -1; }
						
#line 2304 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 31:  {
						{
#line 259 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_DOUBLE; double_value = -(double)integer; }
						
#line 2313 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 32:  {
						{
#line 260 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_DOUBLE; double_value = integer; }
						
#line 2322 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 33:  {
						{
#line 261 "src/txt/readstat_spss_commands_read.rl"
							first_integer = integer; }
						
#line 2331 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 34:  {
						{
#line 261 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_RANGE; }
						
#line 2340 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 35:  {
						{
#line 262 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_STRING; }
						
#line 2349 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
				}
				_nacts -= 1;
				_acts += 1;
			}
			
		}
		
		if ( p == eof ) {
			if ( cs >= 628 )
				goto _out;
		}
		else {
			if ( cs != 0 ) {
				p += 1;
				goto _resume;
			}
		}
		_out: {}
	}
	
#line 312 "src/txt/readstat_spss_commands_read.rl"
	
	
	/* suppress warnings */
	(void)spss_commands_en_main;
	
	if (cs < 
#line 2380 "src/txt/readstat_spss_commands_read.c"
	628
#line 317 "src/txt/readstat_spss_commands_read.rl"
	) {
		char error_buf[1024];
		if (p == pe) {
			snprintf(error_buf, sizeof(error_buf), "Error parsing SPSS command file (end-of-file unexpectedly reached)");
		} else {
			snprintf(error_buf, sizeof(error_buf), "Error parsing SPSS command file around line #%d, col #%ld (%c)",
			line_no + 1, (long)(p - line_start + 1), *p);
		}
		if (parser->handlers.error) {
			parser->handlers.error(error_buf, user_ctx);
		}
		error = READSTAT_ERROR_PARSE;
		goto cleanup;
	}
	
	error = submit_columns(parser, schema, user_ctx);
	
	cleanup:
	parser->io->close(parser->io->io_ctx);
	free(bytes);
	if (error != READSTAT_OK) {
		if (outError)
			*outError = error;
		readstat_schema_free(schema);
		schema = NULL;
	}
	
	return schema;
}
