% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHCE.R
\name{simHCE}
\alias{simHCE}
\title{Simulate \code{hce} object with given event rates of time-to-event outcomes (Weibull), mean and SD of the continuous outcome (normal or log-normal) by treatment group}
\usage{
simHCE(
  n,
  n0 = n,
  TTE_A,
  TTE_P,
  CM_A,
  CM_P,
  CSD_A = 1,
  CSD_P = CSD_A,
  fixedfy = 1,
  yeardays = 360,
  pat = 100,
  shape = 1,
  theta = 1,
  logC = FALSE,
  seed = NULL,
  dec = 2,
  all_data = FALSE
)
}
\arguments{
\item{n}{sample size in the active treatment group.}

\item{n0}{sample size in the placebo group.}

\item{TTE_A}{event rates per year in the active group for the time-to-event outcomes.}

\item{TTE_P}{event rates per year in the placebo group for the time-to-event outcomes. Should have the same length as \code{TTE_A}.}

\item{CM_A}{mean value for the continuous outcome of the active group.}

\item{CM_P}{mean value for the continuous outcome of the placebo group.}

\item{CSD_A}{standard deviation for the continuous outcome of the active group.}

\item{CSD_P}{standard deviation for the continuous outcome of the placebo group.}

\item{fixedfy}{length of follow-up in years.}

\item{yeardays}{number of days in a year.}

\item{pat}{scale of provided event rates (per \code{pat}-years).}

\item{shape}{shape of the Weibull distribution for time-to-event outcomes. Default is exponential distribution with \code{shape = 1}.}

\item{theta}{Gumbel dependence coefficient of the Weibull distributions for time-to-event outcomes. Default is \code{theta = 1} which assumes independence of time-to-event outcomes. Must be above or equal to 1.}

\item{logC}{logical, whether to use log-normal distribution for the continuous outcome.}

\item{seed}{for generating random numbers.}

\item{dec}{decimal places for the continuous outcome used for rounding. The default is \code{dec = 2}.}

\item{all_data}{logical, whether to return source datasets \code{ADET} (an event-time dataset for all time-to-event outcomes per patient) and \code{BDS} (a basic data structure for the continuous outcome for all patients).}
}
\value{
an object of class \code{hce} containing the following columns:
\itemize{
\item ID subject identifier.
\item TRTP planned treatment group - "A" for active, "P" for Placebo.
\item GROUP type of the outcome, either "TTE" for time-to-event outcomes or "C" for continuous.
Only one continuous outcome is possible, but no restriction on the number of "TTE" outcomes.
\item GROUPN order of outcomes in \code{GROUP}, with a higher value signifying a better outcome.
\item AVALT the timing of the time-to-event outcomes.
\item AVAL0 numeric values of the continuous outcome and the timing of "TTE" outcomes.
\item AVAL analysis values derived as \code{AVAL0 + GROUPN}. For the continuous outcome the values of \code{AVAL0} are shifted to start always from 0.
\item seed the seed of the random sample. If not specified in \code{seed} argument will be selected based on system time.
\item PADY primary analysis day, the length of fixed follow-up in days calculated as \code{yeardays} multiplied by \code{fixedfy}.
}

If \code{all_data = TRUE}, the function returns a list containing the \code{hce} dataset, along with its source datasets: \code{ADET} (an event-time dataset for all time-to-event outcomes per patient) and \code{BDS} (a basic data structure for the continuous outcome for all patients).
}
\description{
Simulate \code{hce} object with given event rates of time-to-event outcomes (Weibull), mean and SD of the continuous outcome (normal or log-normal) by treatment group
}
\examples{
# Example 1
Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
dat <- simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
              CM_A = -3, CM_P = -6, CSD_A = 16, CSD_P = 15, fixedfy = 3)
head(dat)

# Example 2
Rates_A <- 10
Rates_P <- 15
dat <- simHCE(n = 1000, n0 = 500, TTE_A = Rates_A, TTE_P = Rates_P, 
              CM_A = 0.1, CM_P = 0, seed = 5, shape = 0.2, logC = TRUE, dec = 0)
summaryWO(dat)

# Example 3: Comparison of dependent and independent outcomes
Rates_A <- c(10, 20)
Rates_P <- c(20, 20)
dat1 <- simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P, 
CM_A = -3, CM_P = -6, CSD_A = 15, fixedfy = 3, theta = 1, seed = 1)
dat2 <- simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P, 
CM_A = -3, CM_P = -6, CSD_A = 15, fixedfy = 3, theta = 1.0001, seed = 1)
calcWO(dat1)
calcWO(dat2)
}
\seealso{
\code{\link[=hce]{hce()}}, \code{\link[=as_hce]{as_hce()}} for the helper a coerce function to \code{hce} objects.
}
