% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryWO_formula.R
\name{summaryWO.formula}
\alias{summaryWO.formula}
\title{Win odds summary using formula syntax}
\usage{
\method{summaryWO}{formula}(x, data, ...)
}
\arguments{
\item{x}{an object of class formula.}

\item{data}{a data frame.}

\item{...}{additional parameters.}
}
\value{
a list containing the summary of wins, losses, and ties. It contains the following named objects:
\itemize{
\item summary a data frame containing number of wins, losses, and ties by treatment group and the overall number of comparisons.
\item WO calculated WO (win odds) and WP (win probability) and their standard errors.
\item formula returning the specified formula in the \code{x} argument.
\item ref showing how the reference group was selected. Can be modifying by specifying the \code{ref} argument.
}
}
\description{
Win odds summary using formula syntax
}
\examples{
summaryWO(data = COVID19, GROUP ~ TRTP)
summaryWO(data = COVID19, GROUP ~ TRTP, GROUP = "GROUP", ref = "Placebo")
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=summaryWO]{summaryWO()}}, \code{\link[=summaryWO.data.frame]{summaryWO.data.frame()}}, \code{\link[=summaryWO.hce]{summaryWO.hce()}}  methods.
}
