% Generated by roxygen2 (4.0.2): do not edit by hand
\name{TRMM}
\alias{TRMM}
\title{Download and convert TRMM data}
\usage{
TRMM(fileLocation = "~/",
  url = "ftp://disc2.nascom.nasa.gov/data/TRMM/Gridded/", product = "3B43",
  version = 7, year = 2012, type = "precipitation.accum", bbox = NULL,
  timeExtent = NULL)
}
\arguments{
\item{fileLocation}{file path where to save the GeoTiff}

\item{url}{url where data is stored (e.g. "ftp://disc2.nascom.nasa.gov/data/TRMM/Gridded/3B43_V7/2012/")}

\item{product}{this is the code that identifies a product, default is "3B43"}

\item{version}{this is the version number, default is 7}

\item{year}{year of interest, default is 2012}

\item{type}{this is the type of information needed, default is "precipitation.accum". Other types could be "gaugeRelativeWeighting.bin" and "relativeError.bin"}

\item{bbox}{bounding box, a list made of 4 elements: minimum longitude (lonMin), minimum latitude (latMin), maximum longitude (lonMax), maximum latitude (latMax)}

\item{timeExtent}{is a vector of dates and times for which the data should be retrieve}
}
\value{
Data is loaded as rasterbrick, then converted to a multilayer Geotiff that can
}
\description{
The TRMM dataset provide global historical rainfall estimation in a gridded format.
}
\details{
This code is based upon Martin Brandt's blog post:
http://matinbrandt.wordpress.com/2013/09/04/automatically-downloading-and-processing-trmm-rainfall-data/
and on the TRMM FAQ: http://disc.sci.gsfc.nasa.gov/additional/faq/precipitation_faq.shtml
}
\examples{
# Define a bounding box
# bbox <- list(lonMin=-3.82,latMin=52.41,lonMax=-3.63,latMax=52.52)

# TRMM(product="3B43",
#      version=7,
#      year=2012,
#      bbox)
}
\author{
Claudia Vitolo
}

