% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRDC.R
\name{catalogueGRDC}
\alias{catalogueGRDC}
\title{Interface for the Global Runoff Data Centre database catalogue}
\usage{
catalogueGRDC(bbox = NULL, stationID = NULL, metadataColumn = NULL,
  entryValue = NULL, mdDescription = FALSE)
}
\arguments{
\item{bbox}{bounding box, a list made of 4 elements: minimum longitude (lonMin), minimum latitude (latMin), maximum longitude (lonMax), maximum latitude (latMax)}

\item{stationID}{Station ID number, it should be in the range [1104150,6990700]}

\item{metadataColumn}{name of the column to filter}

\item{entryValue}{value to look for in the column named metadataColumn}

\item{mdDescription}{boolean value. Default is FALSE (no description is printed)}
}
\value{
list of stations within the bounding box
}
\description{
This function interfaces the Global Runoff Data Centre database which provides river discharge data for about 9000 sites over 157 countries.
}
\examples{
\dontrun{
  # Retrieve the whole catalogue
  catalogueGRDC()

  # Define a bounding box
  bbox <- list(lonMin=-3.82,latMin=52.41,lonMax=-3.63,latMax=52.52)

  # Filter the catalogue
  catalogueGRDC(bbox)
}

}
\author{
Claudia Vitolo
}

