// (c) The HDF Group
#ifndef H5PTpublic_H
#define H5PTpublic_H
#ifdef __cplusplus
extern "C" {
#endif
H5_HLDLL hid_t H5PTcreate(hid_t loc_id, const char *dset_name, hid_t dtype_id, hsize_t chunk_size,
                          hid_t plist_id);
H5_HLDLL hid_t H5PTopen(hid_t loc_id, const char *dset_name);
H5_HLDLL herr_t H5PTclose(hid_t table_id);
H5_HLDLL hid_t H5PTcreate_fl(hid_t loc_id, const char *dset_name, hid_t dtype_id, hsize_t chunk_size,
                             int compression);
H5_HLDLL herr_t H5PTappend(hid_t table_id, size_t nrecords, const void *data);
H5_HLDLL herr_t H5PTget_next(hid_t table_id, size_t nrecords, void *data);
H5_HLDLL herr_t H5PTread_packets(hid_t table_id, hsize_t start, size_t nrecords, void *data);
H5_HLDLL herr_t H5PTget_num_packets(hid_t table_id, hsize_t *nrecords);
H5_HLDLL herr_t H5PTis_valid(hid_t table_id);
H5_HLDLL herr_t H5PTis_varlen(hid_t table_id);
H5_HLDLL hid_t H5PTget_dataset(hid_t table_id);
H5_HLDLL hid_t H5PTget_type(hid_t table_id);
H5_HLDLL herr_t H5PTcreate_index(hid_t table_id);
H5_HLDLL herr_t H5PTset_index(hid_t table_id, hsize_t pt_index);
H5_HLDLL herr_t H5PTget_index(hid_t table_id, hsize_t *pt_index);
H5_HLDLL herr_t H5PTfree_vlen_buff(hid_t table_id, size_t bufflen, void *buff);
#ifdef __cplusplus
}
#endif
#endif
