// (c) The HDF Group
#ifndef H5ESpublic_H
#define H5ESpublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#define H5ES_NONE 0
#define H5ES_WAIT_FOREVER (UINT64_MAX)
#define H5ES_WAIT_NONE (0)
typedef enum H5ES_status_t {
    H5ES_STATUS_IN_PROGRESS,
    H5ES_STATUS_SUCCEED,
    H5ES_STATUS_CANCELED,
    H5ES_STATUS_FAIL
} H5ES_status_t;
typedef struct H5ES_op_info_t {
    const char *api_name;
    char       *api_args;
    const char *app_file_name;
    const char *app_func_name;
    unsigned    app_line_num;
    uint64_t op_ins_count;
    uint64_t op_ins_ts;
    uint64_t op_exec_ts;
    uint64_t op_exec_time;
} H5ES_op_info_t;
//! <!-- [H5ES_err_info_t_snip] -->
typedef struct H5ES_err_info_t {
    char *api_name;
    char *api_args;
    char    *app_file_name;
    char    *app_func_name;
    unsigned app_line_num;
    uint64_t op_ins_count;
    uint64_t op_ins_ts;
    uint64_t op_exec_ts;
    uint64_t op_exec_time;
    hid_t err_stack_id;
} H5ES_err_info_t;
//! <!-- [H5ES_err_info_t_snip] -->
typedef int (*H5ES_event_insert_func_t)(const H5ES_op_info_t *op_info, void *ctx);
typedef int (*H5ES_event_complete_func_t)(const H5ES_op_info_t *op_info, H5ES_status_t status,
                                          hid_t err_stack, void *ctx);
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5EScreate(void);
H5_DLL herr_t H5ESwait(hid_t es_id, uint64_t timeout, size_t *num_in_progress, hbool_t *err_occurred);
H5_DLL herr_t H5EScancel(hid_t es_id, size_t *num_not_canceled, hbool_t *err_occurred);
H5_DLL herr_t H5ESget_count(hid_t es_id, size_t *count);
H5_DLL herr_t H5ESget_op_counter(hid_t es_id, uint64_t *counter);
H5_DLL herr_t H5ESget_err_status(hid_t es_id, hbool_t *err_occurred);
H5_DLL herr_t H5ESget_err_count(hid_t es_id, size_t *num_errs);
H5_DLL herr_t H5ESget_err_info(hid_t es_id, size_t num_err_info, H5ES_err_info_t err_info[],
                               size_t *err_cleared);
H5_DLL herr_t H5ESfree_err_info(size_t num_err_info, H5ES_err_info_t err_info[]);
H5_DLL herr_t H5ESregister_insert_func(hid_t es_id, H5ES_event_insert_func_t func, void *ctx);
H5_DLL herr_t H5ESregister_complete_func(hid_t es_id, H5ES_event_complete_func_t func, void *ctx);
H5_DLL herr_t H5ESclose(hid_t es_id);
#ifdef __cplusplus
}
#endif
#endif
