% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_COMPOUND-class}
\alias{H5T_COMPOUND-class}
\alias{H5T_COMPOUND}
\title{Class for HDF5 compound datatypes.}
\value{
Object of class \code{\link[=H5T_COMPOUND]{H5T_COMPOUND}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}.
}
\section{Methods}{

\describe{
\item{\code{new(labels, dtypes, size = NULL, offset = NULL, id = NULL)}}{

Create at compound type that is the HDF5 equivalent of a table

\strong{Parameters}
\describe{
\item{labels}{The labels of the columns of the compound object}
\item{dtypes}{The datatypes of the columns of the object; this is usually a list of objects
of class \code{\link{H5T}}}
\item{size}{The size of each datatype; if \code{NULL}, automatically inferred}
\item{offset}{The offset where each datatype starts; can be different from the sum of the individual sizes
so that datatypes are aligned with memory addresses. If \code{NULL}, inferred automatically}
\item{id}{Internal use only}
}}

\item{\code{pack()}}{

This function implements the HDF5-API function H5Tpack.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_cpd_types()}}{

Return \code{\link{H5T}} objects that represent the datatypes of the columns of the 
compound object. Returned as a list if more than 1}

\item{\code{get_cpd_labels()}}{

Return the labels of the columns as a character vector}

\item{\code{get_cpd_classes()}}{

Return the classes of the columns as an object of type \code{\link{factor_ext}}}

\item{\code{get_cpd_offsets()}}{

Return the offsets of the datatypes}

\item{\code{describe()}}{

Print a detailed description of the datatype; this is experimental}
}}

\examples{
# create a H5T_COMPOUND  corresponding to a data-frame
my_cpd <- H5T_COMPOUND$new(c("name", "age", "salary"),
    dtypes=list(H5T_STRING$new(size=200), h5types$H5T_NATIVE_INT, h5types$H5T_NATIVE_DOUBLE))
my_cpd
}
\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
