% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5P.R
\docType{class}
\name{H5P_DATASET_XFER-class}
\alias{H5P_DATASET_XFER-class}
\alias{H5P_DATASET_XFER}
\title{Class for HDF5 property list for dataset transfer}
\value{
Object of class \code{\link[=H5P_DATASET_XFER]{H5P_DATASET_XFER}}.
}
\description{
It inherits all functions of the \code{\link{H5P}}.
}
\section{Methods}{

\describe{
\item{\code{new(id = NULL)}}{

Create a new class of type \code{\link{H5P_DATASET_XFER}}

\strong{Parameters}
\describe{
\item{id}{Internal use only}
}}

\item{\code{set_buffer(size = 2^20)}}{

This function implements the HDF5-API function H5Pset_buffer.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{set_edc_check(check = h5const$H5Z_ENABLE_EDC)}}{

This function implements the HDF5-API function H5Pset_edc_check.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{get_edc_check()}}{

This function implements the HDF5-API function H5Pget_edc_check.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{set_hyper_vector_size(size = 2^10)}}{

This function implements the HDF5-API function H5Pset_hyper_vector_size.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{get_hyper_vector_size()}}{

This function implements the HDF5-API function H5Pget_hyper_vector_size.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{set_btree_ratios(left, middle, right)}}{

This function implements the HDF5-API function H5Pset_btree_ratios.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{get_btree_ratios()}}{

This function implements the HDF5-API function H5Pget_btree_ratios.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}
}}

\seealso{
\code{\link[=H5P]{H5P}}
}
\author{
Holger Hoefling
}
