% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassoIVselectX.R
\name{rlassoIVselectX}
\alias{rlassoIVselectX}
\alias{rlassoIVselectX.default}
\alias{rlassoIVselectX.formula}
\title{Instrumental Variable Estimation with Selection on the exogenous Variables by Lasso}
\usage{
rlassoIVselectX(x, ...)

\method{rlassoIVselectX}{default}(x, d, y, z, post = TRUE, ...)

\method{rlassoIVselectX}{formula}(formula, data, post = TRUE, ...)
}
\arguments{
\item{x}{exogenous variables in the structural equation (matrix)}

\item{d}{endogenous variables in the structural equation (vector or matrix)}

\item{y}{outcome or dependent variable in the structural equation (vector or matrix)}

\item{z}{set of potential instruments for the endogenous variables.}

\item{post}{logical. If \code{TRUE}, post-lasso estimation is conducted.}

\item{formula}{An object of class \code{Formula} of the form " y ~ x + d | x + z" with y the outcome variable,
d endogenous variable, z instrumental variables, and x exogenous variables.}

\item{data}{An optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from environment(formula), typically the environment from which \code{rlassoIVselectX} is called.}

\item{\dots}{arguments passed to the function \code{rlasso}}
}
\value{
An object of class \code{rlassoIVselectX} containing at least the following
components: \item{coefficients}{estimated parameter vector}
\item{vcov}{variance-covariance matrix} \item{residuals}{
residuals} \item{samplesize}{sample size}
}
\description{
This function estimates the coefficient of an endogenous variable by employing Instrument Variables in a setting where the exogenous variables are high-dimensional and hence
selection on the exogenous variables is required.
The function returns an element of class \code{rlassoIVselectX}
}
\details{
The implementation is a special case of of Chernozhukov et al. (2015).
The option \code{post=TRUE} conducts post-lasso estimation for the Lasso estimations, i.e. a refit of the
model with the selected variables. Exogenous variables 
\code{x} are automatically used as instruments and added to the
instrument set \code{z}.
}
\examples{
library(hdm)
data(AJR); y = AJR$GDP; d = AJR$Exprop; z = AJR$logMort
x = model.matrix(~ -1 + (Latitude + Latitude2 + Africa + 
                           Asia + Namer + Samer)^2, data=AJR)
dim(x)
  #AJR.Xselect = rlassoIV(x=x, d=d, y=y, z=z, select.X=TRUE, select.Z=FALSE)
  AJR.Xselect = rlassoIV(GDP ~ Exprop +  (Latitude + Latitude2 + Africa + Asia + Namer + Samer)^2 |
             logMort +  (Latitude + Latitude2 + Africa + Asia + Namer + Samer)^2,
             data=AJR, select.X=TRUE, select.Z=FALSE)
summary(AJR.Xselect)
confint(AJR.Xselect)
}
\references{
Chernozhukov, V., Hansen, C. and M. Spindler (2015). Post-Selection and Post-Regularization Inference in Linear
Models with Many Controls and Instruments
\emph{American Economic Review, Papers and Proceedings} 105(5), 486--490.
}

