% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear-mixed-model-deployment.R
\docType{class}
\name{LinearMixedModelDeployment}
\alias{LinearMixedModelDeployment}
\title{Deploy a production-ready predictive Random Forest model}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
LinearMixedModelDeployment(type, df, 
grainCol, personCol, testWindowCol, predictedCol, impute, debug)
}
\arguments{
\item{type}{The type of model (either 'regression' or 'classification')}

\item{df}{Dataframe whose columns are used for calc.}

\item{grainCol}{The data frame's column that has IDs pertaining to the grain}

\item{personCol}{The data frame's columns that represents the patient/person}

\item{testWindowCol}{This column dictates the split between model training and
test sets. Those rows with zeros in this column indicate the training set
while those that have ones indicate the test set}

\item{predictedCol}{Column that you want to predict.}

\item{impute}{For training df, set all-column imputation to F or T.
This uses mean replacement for numeric columns
and most frequent for factorized columns.
F leads to removal of rows containing NULLs.}

\item{debug}{Provides the user extended output to the console, in order
to monitor the calculations throughout. Use T or F.}
}
\description{
This step allows one to
\itemize{
\item Create a final model on all of your training data
\item Automatically save the model
\item Run the model against test data to generate predictions
\item Push these predictions to SQL Server
}
}
\examples{
#### Classification example using diabetes data ####
# This example requires you to first create a table in SQL Server
# If you prefer to not use SAMD, execute this in SSMS to create output table:
# CREATE TABLE dbo.HCRDeployRegressionBASE(
# BindingID float, BindingNM varchar(255), LastLoadDTS datetime2,
# PatientEncounterID int, <--change to match inputID
# PredictedValueNBR decimal(38, 2),
# Factor1TXT varchar(255), Factor2TXT varchar(255), Factor3TXT varchar(255)
# )

\donttest{
#### This example is specific to Windows and is not tested. 
# setwd('C:/Yourscriptlocation/Useforwardslashes') # Uncomment if using csv
ptm <- proc.time()
library(healthcareai)

connection.string <- "
driver={SQL Server};
server=localhost;
database=SAM;
trusted_connection=true
"

query <- "
SELECT
 [PatientEncounterID]
,[PatientID]           --Mixed model needs two ID columns
,[SystolicBPNBR]
,[LDLNBR]
,[A1CNBR]
,[GenderFLG]
,[ThirtyDayReadmitFLG]
,[InTestWindowFLG]
FROM [SAM].[dbo].[HCRDiabetesClinical]
--no WHERE clause, because we want train AND test
"

df <- selectData(connection.string, query)

head(df)

p <- SupervisedModelDeploymentParams$new()
p$type <- "classification"
p$df <- df
p$grainCol <- "PatientEncounterID"
p$testWindowCol <- "InTestWindowFLG"
p$predictedCol <- "ThirtyDayReadmitFLG"
p$personCol <- "PatientID"
p$impute <- FALSE
p$debug <- FALSE
p$useSavedModel <- FALSE
p$cores <- 1
p$sqlConn <- connection.string
p$destSchemaTable <- "dbo.HCRDeployClassificationBASE"

lMM <- LinearMixedModelDeployment$new(p)
lMM$deploy()

print(proc.time() - ptm)

#### Regression example using diabetes data ####
# This example requires you to first create a table in SQL Server
# If you prefer to not use SAMD, execute this in SSMS to create output table:
# CREATE TABLE dbo.HCRDeployRegressionBASE(
#   BindingID float, BindingNM varchar(255), LastLoadDTS datetime2,
#   PatientEncounterID int, <--change to match inputID
#   PredictedValueNBR decimal(38, 2),
#   Factor1TXT varchar(255), Factor2TXT varchar(255), Factor3TXT varchar(255)
# )

# setwd('C:/Yourscriptlocation/Useforwardslashes') # Uncomment if using csv
ptm <- proc.time()
library(healthcareai)

connection.string <- "
driver={SQL Server};
server=localhost;
database=SAM;
trusted_connection=true
"

query <- "
SELECT
 [PatientEncounterID]
,[PatientID]           --Mixed model needs two ID columns
,[SystolicBPNBR]
,[LDLNBR]
,[A1CNBR]
,[GenderFLG]
,[ThirtyDayReadmitFLG]
,[InTestWindowFLG]
FROM [SAM].[dbo].[HCRDiabetesClinical]
--no WHERE clause, because we want train AND test
"

df <- selectData(connection.string, query)

head(df)

p <- SupervisedModelDeploymentParams$new()
p$type <- "regression"
p$df <- df
p$grainCol <- "PatientEncounterID"
p$testWindowCol <- "InTestWindowFLG"
p$predictedCol <- "A1CNBR"
p$personCol <- "PatientID"
p$impute <- TRUE
p$debug <- FALSE
p$useSavedModel <- FALSE
p$cores <- 1
p$sqlConn <- connection.string
p$destSchemaTable <- "dbo.HCRDeployRegressionBASE"

lMM <- LinearMixedModelDeployment$new(p)
lMM$deploy()

print(proc.time() - ptm)
}

}
\seealso{
\code{\link{healthcareai}}
}
\keyword{datasets}
