% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{acceldata_list}
\alias{acceldata_list}
\title{Accelerometer Data Example}
\format{
A list with 4 components:
\describe{
  \item{PA}{A data frame with 1,526 observations and 1,440 variables.
  Each row corresponds to a daily profile, with columns V1 to V1440 representing
  accelerometer counts recorded minute by minute throughout the day.}
  \item{label}{A data frame with 1,526 observations and 3 variables:
  \describe{
    \item{personid}{Integer identifying the individual}
    \item{daylabel}{Integer indicating the label of the day}
    \item{personid2}{Integer providing an alternative identifier of the individual}
  }}
  \item{flag}{A data frame with 1,526 observations and 1,440 variables.
  The structure mirrors that of PA, with values indicating data quality
  (e.g., 0 = valid, 1 = flagged).}
  \item{demo}{A data frame containing demographic information for the 218 participants
  with 5 variables:
  \describe{
    \item{personid}{Integer identifying the participant}
    \item{age}{Integer indicating age}
    \item{sex}{Factor with 2 levels indicating sex}
    \item{bmi}{Numeric variable with body mass index}
    \item{race}{Factor with 2 levels indicating race}
  }}
}
}
\source{
Data taken from the accelmissing package version 2.2.
}
\usage{
data(acceldata_list)
}
\description{
Data example from the 2003-2004 National Health and Nutrition Examination Survey (NHANES)
dataset. This example only includes 218 individuals, which gives 1,526 daily profiles,
from a total of 7,176 participants in the physical activity survey.
}
\details{
The dataset name has been kept as 'acceldata_list' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'list' indicates that the dataset is stored as a list containing multiple data frames.
The original content has not been modified in any way.
}
