% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{motion_sense_list}
\alias{motion_sense_list}
\title{Motion Sense Dataset}
\format{
A list of length 2:
\describe{
  \item{user_acceleration}{Numeric matrix of dimensions 200 × 96 containing acceleration
  measurements for each participant across activities}
  \item{pitch_attitude}{Numeric matrix of dimensions 200 × 96 containing pitch angle
  measurements for each participant across activities}
}
}
\source{
Data taken from the \pkg{ReMFPCA} package version 2.0.0.
}
\usage{
data(motion_sense_list)
}
\description{
This dataset, motion_sense_list, is a list containing smartphone sensor measurements
of user acceleration and pitch attitude collected from 24 individuals performing
various physical activities. The dataset includes time-series data recorded by
accelerometer and gyroscope sensors under consistent environmental conditions.
}
\details{
Participants (n = 24) of varying gender, age, weight, and height performed
four distinct activities: jogging, walking, sitting, and standing.
Additional recordings also included stair movements (upstairs and downstairs).

The dataset name has been kept as 'motion_sense_list' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'list' indicates that the dataset is stored as a list object.
The original content has not been modified in any way.
}
