% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca-data.R
\name{pca_your_recipe}
\alias{pca_your_recipe}
\title{Perform PCA}
\usage{
pca_your_recipe(.recipe_object, .data, .threshold = 0.75)
}
\arguments{
\item{.recipe_object}{The recipe object you want to pass.}

\item{.data}{The full data set that is used in the original recipe object passed
into \code{.recipe_object} in order to obtain the baked data of the transform.}

\item{.threshold}{A number between 0 and 1. A fraction of the total variance
that should be covered by the components.}
}
\value{
A list object with several components.
}
\description{
This is a simple function that will perform PCA analysis on a passed recipe.
}
\details{
This is a simple wrapper around some recipes functions to perform a PCA on a
given recipe. This function will output a list and return it invisible.
All of the components of the analysis will be returned in a list as their own
object that can be selected individually. A scree plot is also included. The
items that get returned are:
\enumerate{
\item pca_transform - This is the pca recipe.
\item variable_loadings
\item variable_variance
\item pca_estimates
\item pca_juiced_estimates
\item pca_baked_data
\item pca_variance_df
\item pca_variance_scree_plt
\item pca_rotation_df
}
}
\examples{
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(purrr))
suppressPackageStartupMessages(library(healthyR.data))
suppressPackageStartupMessages(library(rsample))
suppressPackageStartupMessages(library(recipes))
suppressPackageStartupMessages(library(ggplot2))

data_tbl <- healthyR_data \%>\%
    select(visit_end_date_time) \%>\%
    summarise_by_time(
        .date_var = visit_end_date_time,
        .by       = "month",
        value     = n()
    ) \%>\%
    set_names("date_col","value") \%>\%
    filter_by_time(
        .date_var = date_col,
        .start_date = "2013",
        .end_date = "2020"
    )

splits <- initial_split(data = data_tbl, prop = 0.8)

rec_obj <- recipe(value ~ ., training(splits)) \%>\%
    step_timeseries_signature(date_col) \%>\%
    step_rm(matches("(iso$)|(xts$)|(hour)|(min)|(sec)|(am.pm)"))

output_list <- pca_your_recipe(rec_obj, .data = data_tbl)
output_list$pca_variance_scree_plt

}
\seealso{
\url{https://recipes.tidymodels.org/reference/step_pca.html}

Other Data Wrangling: 
\code{\link{get_juiced_data}()}

Other Data Recipes: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Recipes}
\concept{Data Wrangling}
\concept{Dimension Reduction}
