% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-prep-knn.R
\name{hai_knn_data_prepper}
\alias{hai_knn_data_prepper}
\title{Prep Data for k-NN - Recipe}
\usage{
hai_knn_data_prepper(.data, .recipe_formula)
}
\arguments{
\item{.data}{The data that you are passing to the function. Can be any type
of data that is accepted by the \code{data} parameter of the \code{recipes::reciep()}
function.}

\item{.recipe_formula}{The formula that is going to be passed. For example
if you are using the \code{iris} data then the formula would most likely be something
like \code{Species ~ .}}
}
\value{
A recipe object
}
\description{
Automatically prep a data.frame/tibble for use in the k-NN algorithm.
}
\details{
This function will automatically prep your data.frame/tibble for
use in the k-NN algorithm. The k-NN algorithm is a lazy learning classification
algorithm. It expects data to be presented in a certain fashion.

This function will output a recipe specification.
}
\examples{
library(ggplot2)

hai_knn_data_prepper(.data = Titanic, .recipe_formula = Survived ~ .)
rec_obj <- hai_knn_data_prepper(iris, Species ~ .)
get_juiced_data(rec_obj)

}
\seealso{
Other Preprocessor: 
\code{\link{hai_c50_data_prepper}()},
\code{\link{hai_cubist_data_prepper}()},
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()},
\code{\link{hai_earth_data_prepper}()},
\code{\link{hai_glmnet_data_prepper}()},
\code{\link{hai_ranger_data_prepper}()},
\code{\link{hai_svm_poly_data_prepper}()},
\code{\link{hai_svm_rbf_data_prepper}()},
\code{\link{hai_xgboost_data_prepper}()}

Other knn: 
\code{\link{hai_glmnet_data_prepper}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Preprocessor}
\concept{knn}
