% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dl-cms-data.R
\name{fetch_cms_data}
\alias{fetch_cms_data}
\title{Fetch Data as Tibble}
\usage{
fetch_cms_data(.data_link)
}
\arguments{
\item{.data_link}{A character string containing the URL to fetch data from.}
}
\value{
A tibble containing the fetched data with cleaned names. If an error
occurs, returns \code{NULL}.
}
\description{
This function retrieves data from the provided link and returns it as a tibble
with cleaned names. This function is intended to be used with the CMS data API
function \code{\link[healthyR.data]{get_cms_meta_data}}.
}
\details{
The function sends a request to the provided URL using \code{httr2::request} and
\code{httr2::req_perform}. If the response status is not 200, it stops with an
error message indicating the failure. The response body is parsed as JSON and
converted into a tibble using \code{dplyr::as_tibble}. The column names are cleaned
using \code{janitor::clean_names}, and any character columns are stripped of leading
and trailing whitespace using \code{stringr::str_squish}.
}
\examples{
library(dplyr)

# Example usage:
base_url <- "https://data.cms.gov/data-api/v1/dataset/"
data_identifier <- "9767cb68-8ea9-4f0b-8179-9431abc89f11"
data_url <- paste0(base_url, data_identifier, "/data")

df_tbl <- fetch_cms_data(data_url)

df_tbl |>
 head(1) |>
 glimpse()

}
\seealso{
\code{\link[healthyR.data]{get_cms_meta_data}}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{CMS Data}
