% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-ets-reg.R
\name{ts_wfs_ets_reg}
\alias{ts_wfs_ets_reg}
\title{Auto ETS Workflowset Function}
\usage{
ts_wfs_ets_reg(
  .model_type = "all_engines",
  .recipe_list,
  .seasonal_period = "auto",
  .error = "auto",
  .trend = "auto",
  .season = "auto",
  .damping = "auto",
  .smooth_level = 0.1,
  .smooth_trend = 0.1,
  .smooth_seasonal = 0.1
)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[modeltime:exp_smoothing]{modeltime::exp_smoothing()}} under the hood and can take one of the following:
\itemize{
\item "ets"
\item "croston"
\item "theta"
\item "smooth_es"
\item "all_engines" - This will make a model spec for all available engines.
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.seasonal_period}{A seasonal frequency. Uses "auto" by default.
A character phrase of "auto" or time-based phrase of "2 weeks" can be used
if a date or date-time variable is provided. See Fit Details below.}

\item{.error}{The form of the error term: "auto", "additive", or
"multiplicative". If the error is multiplicative, the data must be non-negative.}

\item{.trend}{The form of the trend term: "auto", "additive", "multiplicative"
or0 "none".}

\item{.season}{The form of the seasonal term: "auto", "additive",
"multiplicative" or "none".}

\item{.damping}{Apply damping to a trend: "auto", "damped", or "none".}

\item{.smooth_level}{This is often called the "alpha" parameter used as the
base level smoothing factor for exponential smoothing models.}

\item{.smooth_trend}{This is often called the "beta" parameter used as the
trend smoothing factor for exponential smoothing models.}

\item{.smooth_seasonal}{This is often called the "gamma" parameter used as
the seasonal smoothing factor for exponential smoothing models.}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the model specification, but if you choose you can set them
yourself if you have a good understanding of what they should be. The mode is
set to "regression".

This uses the following engines:

\code{\link[modeltime:exp_smoothing]{modeltime::exp_smoothing()}} exp_smoothing() is a way to generate a specification
of an Exponential Smoothing model before fitting and allows the model to be
created using different packages. Currently the only package is forecast.
Several algorithms are implemented:
\itemize{
\item "ets"
\item "croston"
\item "theta"
\item "smooth_es
}
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(tidymodels))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_ets_reg("all_engines", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

\url{https://business-science.github.io/modeltime/reference/exp_smoothing.html}

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
