% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-log-trans-stationary.R
\name{util_log_ts}
\alias{util_log_ts}
\title{Logarithmic Transformation to Make Time Series Stationary}
\usage{
util_log_ts(.time_series)
}
\arguments{
\item{.time_series}{A time series object to be made stationary.}
}
\value{
If the time series is already stationary or the logarithmic transformation is successful,
it returns a list as described in the details section. If the transformation fails,
it returns a list with ret set to FALSE.
}
\description{
This function attempts to make a non-stationary time series stationary
by applying a logarithmic transformation. If successful, it returns the stationary
time series. If the transformation fails, it informs the user.
}
\details{
This function checks if the minimum value of the input time series is greater than or equal to zero.
If yes, it performs the Augmented Dickey-Fuller test on the logarithm of the time series.
If the p-value of the test is less than 0.05, it concludes that the logarithmic transformation
made the time series stationary and returns the result as a list with the following elements:
\itemize{
\item stationary_ts: The stationary time series after the logarithmic transformation.
\item ndiffs: Not applicable in this case, marked as NA.
\item adf_stats: Augmented Dickey-Fuller test statistics on the stationary time series.
\item trans_type: Transformation type, which is "log" in this case.
\item ret: TRUE to indicate a successful transformation.
}

If the minimum value of the time series is less than or equal to 0 or if the logarithmic
transformation doesn't make the time series stationary, it informs the user and returns
a list with ret set to FALSE.
}
\examples{
# Example 1: Using a time series dataset
util_log_ts(AirPassengers)

# Example 2: Using a different time series dataset
util_log_ts(BJsales.lead)$ret

}
\seealso{
Other Utility: 
\code{\link{auto_stationarize}()},
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_lag_correlation}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_model_spec_tune_template}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()},
\code{\link{util_difflog_ts}()},
\code{\link{util_doublediff_ts}()},
\code{\link{util_doubledifflog_ts}()},
\code{\link{util_singlediff_ts}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
