% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans-funcs.R
\name{kmeans_mapped_tbl}
\alias{kmeans_mapped_tbl}
\title{K-Means Mapper}
\usage{
kmeans_mapped_tbl(.data, .centers = 15)
}
\arguments{
\item{.data}{You must have a tibble in the working environment from the
\code{\link[=kmeans_user_item_tbl]{kmeans_user_item_tbl()}}}

\item{.centers}{How many different centers do you want to try}
}
\value{
A nested tibble
}
\description{
Create a tibble that maps the \code{\link[=kmeans_obj]{kmeans_obj()}} using \code{\link[purrr:map]{purrr::map()}}
to create a nested data.frame/tibble that holds n centers. This tibble will be
used to help create a scree plot.
}
\details{
Takes in a single parameter of .centers. This is used to create the tibble
and map the \code{\link[=kmeans_obj]{kmeans_obj()}} function down the list creating a nested tibble.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data\%>\%
   filter(ip_op_flag == "I") \%>\%
   filter(payer_grouping != "Medicare B") \%>\%
   filter(payer_grouping != "?") \%>\%
   select(service_line, payer_grouping) \%>\%
   mutate(record = 1) \%>\%
   as_tibble()

ui_tbl <-  kmeans_user_item_tbl(data_tbl, service_line, payer_grouping)

kmeans_mapped_tbl(ui_tbl)

}
\seealso{
\url{https://en.wikipedia.org/wiki/Scree_plot}
}
\author{
Steven P. Sanderson II, MPH
}
