% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaply.R
\name{heatmaply}
\alias{heatmaply}
\alias{heatmaply_na}
\alias{heatmaply_cor}
\alias{heatmaply.default}
\alias{heatmaply.heatmapr}
\title{Cluster heatmap based on plotly}
\usage{
heatmaply(x, ...)

heatmaply_na(x, grid_gap = 1, colors = c("grey80", "grey20"), ...)

heatmaply_cor(x, limits = c(-1, 1), colors = cool_warm, ...)

\method{heatmaply}{default}(
  x,
  colors = viridis(n = 256, alpha = 1, begin = 0, end = 1, option = "viridis"),
  limits = NULL,
  na.value = "grey50",
  row_text_angle = 0,
  column_text_angle = 45,
  subplot_margin = 0,
  cellnote = NULL,
  draw_cellnote = !is.null(cellnote),
  cellnote_color = "auto",
  cellnote_textposition = "middle right",
  cellnote_size = 12,
  Rowv,
  Colv,
  distfun = dist,
  hclustfun = hclust,
  dist_method = NULL,
  hclust_method = NULL,
  distfun_row,
  hclustfun_row,
  distfun_col,
  hclustfun_col,
  dendrogram = c("both", "row", "column", "none"),
  show_dendrogram = c(TRUE, TRUE),
  reorderfun = function(d, w) reorder(d, w),
  k_row = 1,
  k_col = 1,
  symm = FALSE,
  revC,
  scale = c("none", "row", "column"),
  na.rm = TRUE,
  row_dend_left = FALSE,
  margins = c(NA, NA, NA, NA),
  ...,
  scale_fill_gradient_fun = NULL,
  grid_color = NA,
  grid_gap = 0,
  srtRow,
  srtCol,
  xlab = "",
  ylab = "",
  main = "",
  titleX = TRUE,
  titleY = TRUE,
  hide_colorbar = FALSE,
  key.title = NULL,
  return_ppxpy = FALSE,
  row_side_colors,
  row_side_palette = NULL,
  col_side_colors,
  col_side_palette = NULL,
  ColSideColors = NULL,
  RowSideColors = NULL,
  seriate = c("OLO", "mean", "none", "GW"),
  heatmap_layers = NULL,
  side_color_layers = NULL,
  dendrogram_layers = NULL,
  branches_lwd = 0.6,
  file,
  width = NULL,
  height = NULL,
  long_data,
  plot_method = c("ggplot", "plotly"),
  label_names = NULL,
  fontsize_row = 10,
  fontsize_col = 10,
  cexRow,
  cexCol,
  subplot_widths = NULL,
  subplot_heights = NULL,
  colorbar_len = 0.3,
  colorbar_thickness = 30,
  colorbar_xanchor = if (row_dend_left) "right" else "left",
  colorbar_yanchor = "bottom",
  colorbar_xpos = if (row_dend_left) -0.1 else 1.1,
  colorbar_ypos = 0,
  showticklabels = c(TRUE, TRUE),
  dynamicTicks = FALSE,
  grid_size = 0.1,
  node_type = "heatmap",
  point_size_mat = NULL,
  point_size_name = "Point size",
  label_format_fun = function(...) format(..., digits = 4),
  labRow = NULL,
  labCol = NULL,
  custom_hovertext = NULL,
  col = NULL,
  dend_hoverinfo = TRUE,
  side_color_colorbar_len = 0.3
)

\method{heatmaply}{heatmapr}(
  x,
  colors = viridis(n = 256, alpha = 1, begin = 0, end = 1, option = "viridis"),
  limits = NULL,
  na.value = "grey50",
  row_text_angle = 0,
  column_text_angle = 45,
  subplot_margin = 0,
  row_dend_left = FALSE,
  margins = c(NA, NA, NA, NA),
  ...,
  scale_fill_gradient_fun = scale_fill_gradientn(colors = if (is.function(colors))
    colors(256) else colors, na.value = na.value, limits = limits),
  grid_color = NA,
  grid_gap = 0,
  srtRow,
  srtCol,
  xlab = "",
  ylab = "",
  main = "",
  titleX = TRUE,
  titleY = TRUE,
  hide_colorbar = FALSE,
  key.title = NULL,
  return_ppxpy = FALSE,
  draw_cellnote = FALSE,
  cellnote_color = "auto",
  cellnote_textposition = "middle right",
  cellnote_size = 12,
  row_side_colors = x[["row_side_colors"]],
  row_side_palette = NULL,
  col_side_colors = x[["col_side_colors"]],
  col_side_palette = NULL,
  plot_method = c("ggplot", "plotly"),
  ColSideColors = NULL,
  RowSideColors = NULL,
  heatmap_layers = NULL,
  side_color_layers = NULL,
  dendrogram_layers = NULL,
  branches_lwd = 0.6,
  label_names = c("row", "column", "value"),
  fontsize_row = 10,
  fontsize_col = 10,
  subplot_widths = NULL,
  subplot_heights = NULL,
  colorbar_xanchor = if (row_dend_left) "right" else "left",
  colorbar_yanchor = "bottom",
  colorbar_xpos = if (row_dend_left) -0.1 else 1.1,
  colorbar_ypos = 0,
  colorbar_len = 0.3,
  colorbar_thickness = 30,
  showticklabels = c(TRUE, TRUE),
  dynamicTicks = FALSE,
  node_type = c("scatter", "heatmap"),
  grid_size = 0.1,
  point_size_mat = x[["matrix"]][["point_size_mat"]],
  point_size_name = "Point size",
  label_format_fun = function(...) format(..., digits = 4),
  custom_hovertext = x[["matrix"]][["custom_hovertext"]],
  dend_hoverinfo = TRUE,
  side_color_colorbar_len = 0.3
)
}
\arguments{
\item{x}{can either be a heatmapr object, or a numeric matrix
Defaults to \code{TRUE} unless \code{x} contains any \code{NA}s.}

\item{...}{other parameters passed to \link{heatmapr} (currently, various
parameters may be ignored.}

\item{grid_gap}{this is a fast alternative to grid_color. The default is 0, but if a larger value
is used (for example, 1), then the resulting heatmap will have a white grid which can
help identify different cells. This is implemented using \link[plotly]{style} (with xgap and ygap).}

\item{colors, col}{a vector of colors to use for heatmap color.
The default uses
\code{\link[viridis]{viridis}(n=256, alpha = 1, begin = 0, end = 1, option = "viridis")}
It is passed to \link[ggplot2]{scale_fill_gradientn}.
If colors is a color function (with the first argument being `n` = the number of colors),
it will be used to create 256 colors from that function.
(col is there to stay compatible with \link[gplots]{heatmap.2})}

\item{limits}{a two dimensional numeric vector specifying the data range for the scale.}

\item{na.value}{color to use for missing values (default is "grey50").}

\item{row_text_angle}{numeric (Default is 0), the angle of the text of the
rows. (this is called srtRow in \link[gplots]{heatmap.2})}

\item{column_text_angle}{numeric (Default is 45), the angle of the text of
the columns. (this is called srtCol in \link[gplots]{heatmap.2})}

\item{subplot_margin}{Currently not well implemented. It is passed to
\link[plotly]{subplot}. Default is 0. Either a single value or
 four values (all between 0 and 1). If four values are provided,
 the first is used as the left margin, the second is used as the right margin,
 the third is used as the top margin, and the fourth is used as the bottom margin.
 If a single value is provided, it will be used as all four margins.}

\item{cellnote}{Values to be shown as annotations atop the heatmap cells.}

\item{draw_cellnote}{Should the cellnote annotations be drawn? Defaults is FALSE,
if cellnote is not supplied, TRUE if cellnote is supplied. If TRUE and
cellnote is not supplied, x will be used for cellnote.}

\item{cellnote_color}{The color of the cellnote text to be used.}

\item{cellnote_textposition}{The text positioning/centering of the cellnote.
Default is "middle right". Options are
"top left", "top center", "top right", "middle left", "middle center",
"middle right", "bottom left", "bottom center", "bottom right"}

\item{cellnote_size}{The font size (HTML/CSS) of the cellnote. Default is 12.}

\item{Rowv}{determines if and how the row dendrogram should be reordered.
By default, it is TRUE, which implies dendrogram is computed and reordered
based on row means. If NULL or FALSE, then no dendrogram is computed and
no reordering is done. If a \link{dendrogram} (or \link{hclust}),
then it is used "as-is", ie without any reordering. If a vector of integers,
then dendrogram is computed and reordered based on the order of the vector.}

\item{Colv}{determines if and how the column dendrogram should be reordered.
Has the options as the Rowv argument above and additionally when x is a
square matrix, Colv = "Rowv" means that columns should be treated
identically to the rows.}

\item{distfun}{function used to compute the distance (dissimilarity)
between both rows and columns. Defaults to dist.
The options "pearson", "spearman" and "kendall" can be used to
use correlation-based clustering, which uses \code{as.dist(1 - cor(t(x)))}
as the distance metric (using the specified correlation method).}

\item{hclustfun}{function used to compute the hierarchical clustering
when Rowv or Colv are not dendrograms. Defaults to hclust.}

\item{dist_method}{default is NULL (which results in "euclidean" to be used).
Can accept alternative character strings indicating the
method to be passed to distfun. By default distfun. is \link{dist} hence
this can be one of "euclidean", "maximum", "manhattan", "canberra", "binary"
or "minkowski".}

\item{hclust_method}{default is NULL (which results in "complete" to be used).
Can accept alternative character strings indicating the
method to be passed to hclustfun By default hclustfun is \link{hclust} hence
this can be one of "ward.D", "ward.D2", "single", "complete", "average" 
(= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).
Specifying hclust_method=NA causes heatmaply to use 
\code{\link[dendextend]{find_dend}} to find the "optimal" dendrogram for
the data.}

\item{distfun_row}{distfun for row dendrogram only.}

\item{hclustfun_row}{hclustfun for col dendrogram only.}

\item{distfun_col}{distfun for row dendrogram only.}

\item{hclustfun_col}{hclustfun for col dendrogram only.}

\item{dendrogram}{character string indicating whether to compute 'none', 
'row', 'column' or 'both' dendrograms. Defaults to 'both'. 
However, if Rowv (or Colv) is FALSE or NULL and dendrogram is 'both', 
then a warning is issued and Rowv (or Colv) arguments are honoured.
It also accepts TRUE/FALSE as synonyms for "both"/"none".}

\item{show_dendrogram}{Logical vector of length two, controlling whether 
the row and/or column dendrograms are displayed. If a logical scalar is 
provided, it is repeated to become a logical vector of length two.}

\item{reorderfun}{function(d, w) of dendrogram and weights for reordering the
row and column dendrograms. The default uses stats{reorder.dendrogram}}

\item{k_row}{an integer scalar with the desired number of groups by which to
color the dendrogram's branches in the rows (uses \link[dendextend]{color_branches})
If NA then \link[dendextend]{find_k} is used to deduce the optimal number of clusters.}

\item{k_col}{an integer scalar with the desired number of groups by which to
color the dendrogram's branches in the columns (uses \link[dendextend]{color_branches})
If NA then \link[dendextend]{find_k} is used to deduce the optimal number of clusters.}

\item{symm}{logical indicating if x should be treated symmetrically; can only
be true when x is a square matrix.}

\item{revC}{logical indicating if the column order should be reversed for plotting.
Default (when missing) - is FALSE, unless symm is TRUE.
This is useful for cor matrix.}

\item{scale}{character indicating if the values should be centered and scaled
in either the row direction or the column direction, or none. The default is
"none".}

\item{na.rm}{logical (default is TRUE) indicating whether NA's should be 
removed when scaling (i.e.: when using rowMeans/colMeans). Generally it 
should always be kept as TRUE, and is included here mainly to stay backward 
compatible with gplots::heatmap.2. This argument does not effect the presence
of NA values in the matrix itself. For removing rows/columns with NAs you 
should pre-process your matrix using na.omit (or some form of imputation).}

\item{row_dend_left}{logical (default is FALSE). Should the row dendrogram be
plotted on the left side of the heatmap. If false then it will be plotted on
the right side.}

\item{margins}{numeric vector of length 4 (default is c(50,50,NA,0))
containing the margins (see \link[plotly]{layout}) for column, row and main
title names, respectively. The top margin is NA by default. If main==""
then the top margin will be set to 0, otherwise it will get 30.
For a multiline title a larger default for the 3rd element should be set.
The right margin is NA by default, meaning it will be zero if row_dend_left
is FALSE, or 100 if row_dend_left is TRUE.}

\item{scale_fill_gradient_fun}{A function that creates a smooth gradient for the heatmap.
The default uses \link[ggplot2]{scale_fill_gradientn} with the values of colors, limits, and
na.value that are supplied by the user. The user can input a customized function, such as
\link{scale_color_gradient}() in order to get other results (although the virids default
is quite recommended)}

\item{grid_color}{control the color of the heatmap grid. Default is NA.
Value passed to \link[ggplot2]{geom_tile}. Do not use this parameter on
larger matrix sizes, as it can dramatically prolong the build time of the heatmap.
(another parameter, grid_color, will be added in the future - once it is implemented in plotly)
In the meantime it is MUCH better to use the grid_gap argument.}

\item{srtRow}{if supplied, this overrides row_text_angle (this is to stay compatible with \link[gplots]{heatmap.2})}

\item{srtCol}{if supplied, this overrides column_text_angle (this is to stay compatible with \link[gplots]{heatmap.2})}

\item{xlab}{A character title for the x axis.}

\item{ylab}{A character title for the y axis.}

\item{main}{A character title for the heatmap.}

\item{titleX}{logical (TRUE). should x-axis titles be retained? (passed to \link[plotly]{subplot}).}

\item{titleY}{logical (TRUE). should y-axis titles be retained? (passed to \link[plotly]{subplot}).}

\item{hide_colorbar}{logical (FALSE). If TRUE, then the color bar (i.e.: the legend) is hidden.}

\item{key.title}{(character) main title of the color key. If set to NULL (default) no title will be plotted.}

\item{return_ppxpy}{logical (FALSE). If TRUE, then no plotting is done and the p, px and py objects are
returned (before turning into plotly objects). This is a temporary option which might be removed in the
future just to make it easy to create a ggplot heatmaps.}

\item{row_side_colors, col_side_colors}{data.frame of factors to produce
row/column side colors in the style of heatmap.2/heatmap.3.
When a data.frame is provided, the column names are used as the label names for each of the newly added row_side_colors.
When a vector is provided it is coerced into a data.frame and the name of the side color will be just row_side_colors.}

\item{row_side_palette, col_side_palette}{Color palette functions to be
used for row_side_colors and col_side_colors respectively.}

\item{ColSideColors, RowSideColors}{passed to row_side_colors,col_side_colors in order
to keep compatibility with \link[gplots]{heatmap.2}}

\item{seriate}{character indicating the method of matrix sorting (default: "OLO").
Implemented options include:
"OLO" (Optimal leaf ordering, optimizes the Hamiltonian path length that is
restricted by the dendrogram structure - works in O(n^4) )
"mean" (sorts the matrix based on the reorderfun using marginal means of
the matrix. This is the default used by \link[gplots]{heatmap.2}),
"none" (the default order produced by the dendrogram),
"GW" (Gruvaeus and Wainer heuristic to optimize the Hamiltonian path length
that is restricted by the dendrogram structure)}

\item{heatmap_layers}{ggplot object(s) (eg, list(theme_bw())) to be added to
the heatmap before conversion to a plotly object.}

\item{side_color_layers}{ggplot2 objects to be added to side color plots,
similar to heatmap_layers.}

\item{dendrogram_layers}{ggplot2 objects to be added to dendrograms,
similar to heatmap_layers and side_color_layers.}

\item{branches_lwd}{numeric (default is 0.6). The width of the dendrograms' branches.
If NULL then it is ignored. If the "lwd" is already defined in Rowv/Colv then this
parameter is ignored (it is checked using \link[dendextend]{has_edgePar}("lwd")).}

\item{file}{name of the file(s) into which to save the heatmaply output.
Should be a character vector of strings ending with ".html" for a dynamic output,
or ".png", ".jpeg", ".pdf" for a static output.

For example: heatmaply(x, file = "heatmaply_plot.html") or
dir.create("folder");
heatmaply(x, file = "folder/heatmaply_plot.html")

This is based on \link[htmlwidgets]{saveWidget}, and \link[webshot]{webshot} for the static files.
For more refined control over the static file output, you should save the heatmaply object using \link[plotly]{export} and pass the
arguments you want based on the ones in \link[webshot]{webshot}.

Another example: heatmaply(x, file = c("heatmaply_plot.html", "heatmaply_plot.png"))}

\item{width, height}{The width and height of the image saved. Default is
which uses 800 x 500 pixels.}

\item{long_data}{Data in long format. Replaces x, so both should not be used.
Colnames must be c("name", "variable", "value"). If you do not have a names
column you can simply use a sequence of numbers from 1 to the number of "rows"
in the data.}

\item{plot_method}{Use "ggplot" or "plotly" to choose which library produces heatmap
and dendrogram plots}

\item{label_names}{Names for labels of x, y and value/fill mouseover.}

\item{fontsize_row, fontsize_col, cexRow, cexCol}{Font size for row and column labels.}

\item{subplot_widths, subplot_heights}{The relative widths and heights of each
subplot. The length of these vectors will vary depending on the number of
plots involved.}

\item{colorbar_len}{The length of the colorbar/color key relative to the total
plot height. Only used if plot_method = "plotly"}

\item{colorbar_thickness}{The thickness (width) of the colorbar/color key
in pixels. Only used if plot_method = "plotly".}

\item{colorbar_xanchor, colorbar_yanchor}{The x and y anchoring points of the
colorbar/color legend. Can be "left", "middle" or "right" for colorbar_xanchor,
and "top", "middle" or "bottom" for colorbar_yanchor.
See \code{\link[plotly]{colorbar}} for more details.}

\item{colorbar_xpos, colorbar_ypos}{The x and y co-ordinates (in proportion of the plot window)
of the colorbar/color legend. See \code{\link[plotly]{colorbar}} for more details.}

\item{showticklabels}{A logical vector of length two (default is TRUE).
If FALSE, then the ticks are removed from the sides of the plot. The first location refers to
the x axis and the second to the y axis. If only one value is supplied (TRUE/FALSE) then it is
replicated to get to length 2. When using this parameter, it might be worth also adjusting
margins.
This option should be used when working with medium to large matrix size as it
makes the heatmap much faster (and the hover still works).}

\item{dynamicTicks}{(default: FALSE). passed to \link[plotly]{ggplotly}:
should plotly.js dynamically generate axis tick labels?
Dynamic ticks are useful for updating ticks in response to zoom/pan interactions; however,
they can not always reproduce labels as they would appear in the static ggplot2 image.}

\item{grid_size}{When node_type is "scatter", this controls point size. When
node_type is "heatmap", this controls the size of the grid between heatmap cells.}

\item{node_type}{For plot_method = "ggplot", should the heatmap be rendered as
a x-y scatter plot (node_type = "scatter") or a heatmap (node_type = "heatmap").
Default is node_type = "heatmap".}

\item{point_size_mat}{Matrix to map to point size}

\item{point_size_name}{Name of point size mapping (for hovertext/legend)}

\item{label_format_fun}{Function to format hovertext (eg,
\code{function(...) round(..., digits=3)} or
\code{function(...) format(..., digits=3)}}

\item{labRow, labCol}{character vectors with row and column labels to use;
these default to rownames(x) or colnames(x), respectively.
if set to NA, they change the value in showticklabels to be FALSE. This is mainly to keep
backward compatibility with gplots::heatmap.2.}

\item{custom_hovertext}{Custom hovertext matrix (the same dimensions as the input).
If plot_method is "plotly" then just this text is displayed; if plot_method
if "ggplot" then it is appended to the existing text.}

\item{dend_hoverinfo}{Boolean value which controls whether mouseover text 
is shown for the row and column dendrograms.}

\item{side_color_colorbar_len}{As with colorbar_len, this controls the
length of the colorbar/color key relative to the total plot height. 
This argument controls the colorbar_len of the side colour plots. 
Only used if plot_method = "plotly".}
}
\description{
An object of class heatmapr includes all the needed information
for producing a heatmap. The goal is to separate the pre-processing of the
heatmap elements from the graphical rendering of the object, which could be done

(Please submit an issue on github if you have a feature that you wish to have added)

heatmaply_na is a wrapper for `heatmaply` which comes with defaults that are better
for exploring missing value (NA) patterns. Specifically, the grid_gap is set to 1, and the
colors include two shades of grey. It also calculates the \link{is.na10} automatically.

heatmaply_cor is a wrapper for `heatmaply` which comes with defaults that are better
for correlation matrixes. Specifically, the limits are set from -1 to 1, and the color palette is \link{RdBu}.
}
\examples{

\dontrun{

# mtcars
# x <- heatmapr(mtcars)
library(heatmaply)
heatmaply(iris[,-5], k_row = 3, k_col = 2)
heatmaply(cor(iris[,-5]))
heatmaply(cor(iris[,-5]), limits = c(-1,1))
heatmaply(mtcars, k_row = 3, k_col = 2)
# heatmaply(mtcars, k_row = 3, k_col = 2, grid_color = "white")
heatmaply(mtcars, k_row = 3, k_col = 2, grid_gap = 1)

# make sure there is enough room for the labels:
heatmaply(mtcars, margins = c(40, 130))
# this is the same as using:
heatmaply(mtcars) \%>\% layout(margin = list(l = 130, b = 40))

# control text angle
heatmaply(mtcars, column_text_angle = 90, margins = c(40, 130))
# the same as using srtCol:
# heatmaply(mtcars, srtCol = 90) \%>\% layout(margin = list(l = 130, b = 40))



x <- mtcars
# different colors
heatmaply(x, colors = heat.colors(200))
# using special scale_fill_gradient_fun colors
heatmaply(x, scale_fill_gradient_fun = scale_color_gradient())


# We can join two heatmaps together:
library(heatmaply)
hm1 <- heatmaply(mtcars, margins = c(40, 130))
hm2 <- heatmaply(mtcars, scale = "col", margins = c(40, 130))
subplot(hm1, hm2, margin = .2)

# If we want to share the Y axis, then it is risky to keep any of the dendrograms:
library(heatmaply)
hm1 <- heatmaply(mtcars, Colv = FALSE, Rowv = FALSE, margins = c(40, 130))
hm2 <- heatmaply(mtcars, scale = "col" , Colv = FALSE, Rowv = FALSE,
             margins = c(40, 130))
subplot(hm1, hm2, margin = .02, shareY = TRUE)


# We can save heatmaply as an HTML file by using:
heatmaply(iris[,-5], file = "heatmaply_iris.html")
# or a png/pdf/jpeg file using:
heatmaply(iris[,-5], file = "heatmaply_iris.png")
# or just doing it in one go:
heatmaply(iris[,-5], file = c("heatmaply_iris.html", "heatmaply_iris.png") )



# If we don't want the HTML to be selfcontained, we can use the following:
library(heatmaply)
library(htmlwidgets)
heatmaply(iris[,-5]) \%>\%
   saveWidget(file="heatmaply_iris.html",selfcontained = FALSE)


# Example for using RowSideColors

x  <- as.matrix(datasets::mtcars)
rc <- colorspace::rainbow_hcl(nrow(x))

library(gplots)
library(viridis)
heatmap.2(x, trace = "none", col = viridis(100),
          RowSideColors=rc)

heatmaply(x, seriate = "mean",
          RowSideColors=rc)


heatmaply(x[,-c(8,9)], seriate = "mean",
          col_side_colors = c(rep(0,5), rep(1,4)),
          row_side_colors = x[,8:9])
heatmaply(x[,-c(8,9)], seriate = "mean",
          col_side_colors = data.frame(a=c(rep(0,5), rep(1,4))),
          row_side_colors = x[,8:9])


## Example of using Rowv And Colv for custumized dendrograms.


x  <- as.matrix(datasets::mtcars)

# now let's spice up the dendrograms a bit:
library(dendextend)

row_dend  <- x \%>\% dist \%>\% hclust \%>\% as.dendrogram \%>\%
  set("branches_k_color", k = 3) \%>\% set("branches_lwd", 4) \%>\%
  ladderize
#    rotate_DendSer(ser_weight = dist(x))
col_dend  <- x \%>\% t \%>\% dist \%>\% hclust \%>\% as.dendrogram \%>\%
  set("branches_k_color", k = 2) \%>\% set("branches_lwd", 4) \%>\%
  ladderize
#    rotate_DendSer(ser_weight = dist(t(x)))

heatmaply(x, Rowv = row_dend, Colv = col_dend)


heatmaply(is.na10(airquality))
heatmaply(is.na10(airquality), grid_gap = 1)

# grid_gap can handle quite large data matrix
heatmaply(matrix(1:10000,100,100), k_row = 3, k_col = 3, grid_gap = 1)

# Examples of playing with font size:
heatmaply(mtcars, fontsize_col = 20, fontsize_row = 5, margin = c(100,90))



# Example for using subplot_width/subplot_height

heatmaply(percentize(mtcars),
     subplot_widths=c(0.6, 0.4),
     subplot_heights=c(0.05, 0.95))



# Example of removing labels and thus making the plot faster
heatmaply(iris, showticklabels = c(T,F), margins = c(80,10))

# this is what allows for a much larger matrix to be printed:
set.seed(2017-05-18)
large_x <- matrix(rnorm(19), 1000,100)
heatmaply(large_x, dendrogram = F, showticklabels = F, margins = c(1,1))


}
\dontrun{
heatmaply_na(airquality)
}
\dontrun{
heatmaply_cor(cor(mtcars))
}
}
