% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{compute_counts}
\alias{compute_counts}
\title{Compute Count of Individual in Each State per Cycle}
\usage{
compute_counts(transition_matrix, init, method = c("final", "initial",
  "exponential", "linear"), round = FALSE)
}
\arguments{
\item{transition_matrix}{An \code{eval_matrix} object.}

\item{init}{numeric vector, same length as number of 
model states. Number of individuals in each model state
at the beginning.}

\item{method}{character. One of \code{final},
\code{initial}, \code{exponential} or \code{linear}.
See details.}

\item{round}{logical scalar. Should individual counts be rounded?}
}
\value{
A \code{cycle_counts} object.
}
\description{
Given an initial number of individual and an evaluated 
transition matrix, returns the number of individual per 
state per cycle.
}
\details{
Use the \code{method} argument to specify if transitions
are supposed to happen at the beginning or the end of
each cycle. Alternatively linear interpolation between 
cycles can be performed.
}

