% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{define_state}
\alias{define_state}
\alias{define_state_}
\alias{modify.state}
\title{Define a Markov Model State}
\usage{
define_state(...)

define_state_(.dots)

\method{modify}{state}(.OBJECT, ...)
}
\arguments{
\item{...}{Name-value pairs of expressions defining state
values.}

\item{.dots}{Used to work around non-standard evaluation.}

\item{.OBJECT}{An object of class \code{state}.}
}
\value{
An object of class \code{state} (actually a named
  list of \code{lazy} expressions).
}
\description{
Define the values characterising a Markov Model state for
1 cycle.
}
\details{
As with \code{\link{define_parameters}}, state values are defined
sequencially. Later state definition can thus only refer to values
defined earlier.

For the \code{modify} function, existing values are
modified, no new values can be added. Values order
matters since only values defined earlier can be
referenced in later expressions.
}
\examples{

st <- define_state(
  cost = 6453,
  utility = .876
)
st
}

