% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_cumsum.R
\name{dfr_cumsum}
\alias{dfr_cumsum}
\title{Cumulative Sum for Concept Drift Detection (CUMSUM) method}
\usage{
dfr_cumsum(lambda = 100)
}
\arguments{
\item{lambda}{Necessary level for warning zone (2 standard deviation)}
}
\value{
\code{dfr_cumsum} object
}
\description{
The cumulative sum (CUSUM) is a sequential analysis technique used for change detection.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example assumes a model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4


model <- dfr_cumsum()

detection <- c()
output <- list(obj=model, pred=FALSE)
for (i in 1:length(data$serie)){
 output <- update_state(output$obj, data$serie[i])
 if (output$pred){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, list(idx=i, event=output$pred, type=type))
}

detection <- as.data.frame(detection)
detection[detection$type == 'drift',]
}
